/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.confmgr.Conf;
import com.day.cq.dam.commons.schemaforms.internal.TabList;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.tenant.Tenant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaFormHelper {
    private static final Logger log = LoggerFactory.getLogger(SchemaFormHelper.class);

    @Deprecated
    public static List<Resource> getMasterForms(Resource currentForm, String formsBaseDirPath) throws RepositoryException {
        throw new UnsupportedOperationException("This API has been deprecated. Please use getMasterForms(Resource resource) instead.");
    }

    public static String[] getBaseFormPaths(ResourceResolver resourceResolver) {
        Tenant tenant = resourceResolver.adaptTo(Tenant.class);
        return SchemaFormHelper.getBaseFormPathsFromTenant(resourceResolver, tenant);
    }

    private static String[] getBaseFormPathsFromTenant(ResourceResolver resourceResolver, Tenant tenant) {
        String schemaExtHome = null != tenant ? (String)tenant.getProperty("metadataschema.home") : "/conf/global/settings/dam/adminui-extension/metadataschema";
        String tenantAssetsRoot = null != tenant ? (String)tenant.getProperty("dam:assetsRoot") : "/content/dam";
        String schemaHome = "/libs/dam/content/schemaeditors/forms";
        Resource schemaExtHomeRes = resourceResolver.getResource(schemaExtHome);
        if (null == schemaExtHome || schemaExtHome.trim().isEmpty() || schemaExtHomeRes == null) {
            schemaExtHome = "/conf/global/settings/dam/adminui-extension/metadataschema";
        } else {
            Conf conf = resourceResolver.getResource(tenantAssetsRoot).adaptTo(Conf.class);
            if (conf != null) {
                schemaHome = conf.getItem("dam/adminui").get("metadataschema.home", "/libs/dam/content/schemaeditors/forms");
            }
        }
        return new String[]{schemaExtHome, schemaHome};
    }

    private static String getRelativeFormPath(String formPath, String[] baseFormPaths) {
        for (String baseFormPath : baseFormPaths) {
            if (!formPath.startsWith(baseFormPath)) continue;
            String relativePath = formPath.substring(baseFormPath.length());
            relativePath = relativePath.startsWith("/") ? relativePath : relativePath + "/";
            relativePath = relativePath.endsWith("/") ? relativePath.substring(relativePath.length() - 1) : relativePath;
            return relativePath;
        }
        return formPath;
    }

    public static List<Resource> getMasterForms(Resource currentForm) throws RepositoryException {
        log.warn("This API has been deprectaed.Please use Use getPrimaryForms(Resource resource) instead");
        return SchemaFormHelper.getPrimaryForms(currentForm);
    }

    public static List<Resource> getPrimaryForms(Resource currentForm) throws RepositoryException {
        ResourceResolver resourceResolver = currentForm.getResourceResolver();
        String[] baseFormPaths = SchemaFormHelper.getBaseFormPathsFromTenant(resourceResolver, currentForm.adaptTo(Tenant.class));
        String relativePath = SchemaFormHelper.getRelativeFormPath(currentForm.getPath(), baseFormPaths);
        ArrayList<Resource> primaryFormsList = new ArrayList<Resource>();
        String string = relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf(47));
        while (!relativePath.trim().isEmpty()) {
            for (int i = 0; i < baseFormPaths.length; ++i) {
                String baseFormPath = baseFormPaths[i];
                Resource resToVerify = resourceResolver.getResource(baseFormPath + relativePath);
                if (resToVerify == null || i != baseFormPaths.length - 1 && resToVerify.getChild("items/tabs") == null) continue;
                primaryFormsList.add(resToVerify);
                break;
            }
            relativePath = relativePath.trim().isEmpty() ? "" : relativePath.substring(0, relativePath.lastIndexOf(47));
        }
        Collections.reverse(primaryFormsList);
        return primaryFormsList;
    }

    public static Resource mergeFormTabResource(Resource oneTabList, Resource otherTabList) {
        if (oneTabList == null) {
            return otherTabList;
        }
        if (otherTabList == null) {
            return oneTabList;
        }
        TabList aTab = new TabList(oneTabList);
        TabList oTab = new TabList(otherTabList);
        aTab.merge((Resource)oTab);
        return aTab;
    }

    public static Resource getSchemaResource(SlingHttpServletRequest request) {
        String[] baseFormPaths;
        String suffix = request.getRequestPathInfo().getSuffix();
        suffix = suffix == null ? "" : suffix;
        ResourceResolver resourceResolver = request.getResourceResolver();
        for (String baseFormPath : baseFormPaths = SchemaFormHelper.getBaseFormPaths(resourceResolver)) {
            Resource res = resourceResolver.getResource(baseFormPath + suffix);
            if (null == res) continue;
            return res;
        }
        return null;
    }

    private static String getAppsDir(ResourceResolver resolver) {
        String appsDir = "/apps";
        Tenant tenant = resolver.adaptTo(Tenant.class);
        if (tenant != null) {
            appsDir = appsDir + "/" + tenant.getId();
        }
        return appsDir;
    }

    public static Iterator getSchemaFormsIterator(SlingHttpServletRequest request, int rows, int offset) {
        return SchemaFormHelper.getSchemaFormsIterator(request.getResourceResolver(), request.getRequestPathInfo().getSuffix(), rows, offset);
    }

    public static Iterator getSchemaFormsIterator(ResourceResolver resolver, String suffix, int rows, int offset) {
        String resName;
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        String[] baseFormPaths = SchemaFormHelper.getBaseFormPaths(resolver);
        suffix = null == suffix ? "" : suffix;
        suffix = SchemaFormHelper.getRelativeFormPath(suffix, baseFormPaths);
        String appsResPath = baseFormPaths[0] + suffix;
        String libsResPath = baseFormPaths[1] + suffix;
        Resource appRes = resolver.getResource(appsResPath);
        Resource libsRes = resolver.getResource(libsResPath);
        if (appRes != null) {
            Iterator<Resource> appIter = appRes.listChildren();
            while (appIter.hasNext()) {
                Resource ar = appIter.next();
                resName = Text.getName(ar.getPath());
                if (libsRes != null && libsRes.getChild(resName) != null || !ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                resourceList.add(ar);
            }
        }
        if (libsRes != null) {
            Iterator<Resource> libsIter = libsRes.listChildren();
            while (libsIter.hasNext()) {
                Resource lr = libsIter.next();
                resName = Text.getName(lr.getPath());
                if (appRes != null && appRes.getChild(resName) != null && appRes.getChild(resName).getChild("items/tabs") != null) {
                    Resource ar = resolver.getResource(appRes.getPath() + "/" + resName);
                    if (!ar.isResourceType("nt:folder") && !ar.isResourceType("sling:OrderedFolder") && !ar.isResourceType("sling:Folder")) continue;
                    resourceList.add(ar);
                    continue;
                }
                if ((lr.getChild("items/tabs") == null || !lr.isResourceType("nt:folder")) && !lr.isResourceType("sling:OrderedFolder") && !lr.isResourceType("sling:Folder")) continue;
                resourceList.add(lr);
            }
        }
        return resourceList.iterator();
    }
}

