/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.guava.common.io.Closer;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.composite.CompositeCheckpointMBean;
import org.apache.jackrabbit.oak.composite.CompositeNodeStore;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreStats;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreStatsMBean;
import org.apache.jackrabbit.oak.composite.InitialContentMigrator;
import org.apache.jackrabbit.oak.composite.checks.NodeStoreChecks;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.spi.commit.ObserverTracker;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.jackrabbit.oak.stats.StatisticsProvider;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(policy=ConfigurationPolicy.REQUIRE)
public class CompositeNodeStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(CompositeNodeStoreService.class);
    private static final String GLOBAL_ROLE = "composite-global";
    private static final String MOUNT_ROLE_PREFIX = "composite-mount-";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.STATIC)
    private MountInfoProvider mountInfoProvider;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindNodeStore", unbind="unbindNodeStore", referenceInterface=NodeStoreProvider.class, target="(!(service.pid=org.apache.jackrabbit.oak.composite.CompositeNodeStore))")
    private List<NodeStoreWithProps> nodeStores = new ArrayList<NodeStoreWithProps>();
    @Reference
    private NodeStoreChecks checks;
    @Reference
    private StatisticsProvider statisticsProvider = StatisticsProvider.NOOP;
    @Property(label="Enable node store checks", description="Whether the composite node store constraints should be checked before start", boolValue={true})
    private static final String ENABLE_CHECKS = "enableChecks";
    @Property(label="Pre-populate seed mount", description="Setting this parameter to a mount name will enable pre-populating the empty default store")
    private static final String PROP_SEED_MOUNT = "seedMount";
    @Property(label="Gather path statistics", description="Whether the CompositeNodeStoreStatsMBean should gather information about the most popular paths (may be expensive)", boolValue={false})
    private static final String PATH_STATS = "pathStats";
    private ComponentContext context;
    private final Set<NodeStoreProvider> nodeStoresInUse = Sets.newIdentityHashSet();
    private ServiceRegistration nsReg;
    private Closer mbeanRegistrations;
    private ObserverTracker observerTracker;
    private String seedMount;
    private boolean pathStats;
    private boolean enableChecks;

    @Activate
    protected void activate(ComponentContext context, Map<String, ?> config) throws IOException, CommitFailedException {
        this.context = context;
        this.seedMount = PropertiesUtil.toString(config.get(PROP_SEED_MOUNT), null);
        this.pathStats = PropertiesUtil.toBoolean(config.get(PATH_STATS), false);
        this.enableChecks = PropertiesUtil.toBoolean(config.get(ENABLE_CHECKS), true);
        this.registerCompositeNodeStore();
    }

    @Deactivate
    protected void deactivate() throws IOException {
        this.unregisterCompositeNodeStore();
    }

    private void registerCompositeNodeStore() throws IOException, CommitFailedException {
        if (this.nsReg != null) {
            return;
        }
        NodeStoreWithProps globalNs = this.nodeStores.stream().filter(this::isGlobalNodeStore).findFirst().orElse(null);
        if (globalNs == null) {
            LOG.info("Composite node store registration is deferred until there's a global node store registered in OSGi");
            return;
        }
        LOG.info("Found global node store: {}", (Object)globalNs.getDescription());
        if (!this.allMountsAvailable(this.mountInfoProvider)) {
            return;
        }
        LOG.info("Node stores for all configured mounts are available");
        CompositeNodeStore.Builder builder = new CompositeNodeStore.Builder(this.mountInfoProvider, globalNs.getNodeStoreProvider().getNodeStore());
        this.nodeStoresInUse.add(globalNs.getNodeStoreProvider());
        if (this.enableChecks) {
            builder.with(this.checks);
        }
        for (NodeStoreWithProps ns : this.nodeStores) {
            String mountName;
            if (this.isGlobalNodeStore(ns) || (mountName = this.getMountName(ns)) == null) continue;
            builder.addMount(mountName, ns.getNodeStoreProvider().getNodeStore());
            LOG.info("Mounting {} as {}", (Object)ns.getDescription(), (Object)mountName);
            this.nodeStoresInUse.add(ns.getNodeStoreProvider());
            if (!mountName.equals(this.seedMount)) continue;
            new InitialContentMigrator(globalNs.nodeStore.getNodeStore(), ns.getNodeStoreProvider().getNodeStore(), this.mountInfoProvider.getMountByName(this.seedMount)).migrate();
        }
        CompositeNodeStoreStats nodeStateStats = new CompositeNodeStoreStats(this.statisticsProvider, "NODE_STATE", this.pathStats);
        CompositeNodeStoreStats nodeBuilderStats = new CompositeNodeStoreStats(this.statisticsProvider, "NODE_BUILDER", this.pathStats);
        builder.with(nodeStateStats, nodeBuilderStats);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.pid", CompositeNodeStore.class.getName());
        ((Dictionary)props).put("oak.nodestore.description", new String[]{"nodeStoreType=compositeStore"});
        CompositeNodeStore store = builder.build();
        this.observerTracker = new ObserverTracker(store);
        this.observerTracker.start(this.context.getBundleContext());
        OsgiWhiteboard whiteboard = new OsgiWhiteboard(this.context.getBundleContext());
        this.mbeanRegistrations = Closer.create();
        this.registerMBean(whiteboard, CheckpointMBean.class, new CompositeCheckpointMBean(store), "CheckpointManager", "Composite node store checkpoint management");
        this.registerMBean(whiteboard, CompositeNodeStoreStatsMBean.class, nodeStateStats, "CompositeNodeStoreStats", "Composite node store statistics (node state)");
        this.registerMBean(whiteboard, CompositeNodeStoreStatsMBean.class, nodeBuilderStats, "CompositeNodeStoreStats", "Composite node store statistics (node builder)");
        LOG.info("Registering the composite node store");
        this.nsReg = this.context.getBundleContext().registerService(NodeStore.class.getName(), (Object)store, props);
    }

    private boolean allMountsAvailable(MountInfoProvider mountInfoProvider) {
        Set availableMounts = this.nodeStores.stream().map(this::getMountName).filter(Objects::nonNull).collect(Collectors.toSet());
        for (Mount mount : mountInfoProvider.getNonDefaultMounts()) {
            if (availableMounts.contains(mount.getName())) continue;
            LOG.info("Composite node store registration is deferred until there's mount {} registered in OSGi", (Object)mount.getName());
            return false;
        }
        return true;
    }

    private <T> void registerMBean(Whiteboard whiteboard, Class<T> iface, T bean, String type, String name) {
        Registration reg = WhiteboardUtils.registerMBean(whiteboard, iface, bean, type, name);
        this.mbeanRegistrations.register(reg::unregister);
    }

    private boolean isGlobalNodeStore(NodeStoreWithProps ns) {
        return GLOBAL_ROLE.equals(ns.getRole());
    }

    private String getMountName(NodeStoreWithProps ns) {
        String role = ns.getRole();
        if (role == null || !role.startsWith(MOUNT_ROLE_PREFIX)) {
            return null;
        }
        return role.substring(MOUNT_ROLE_PREFIX.length());
    }

    private void unregisterCompositeNodeStore() throws IOException {
        if (this.nsReg != null) {
            LOG.info("Unregistering the composite node store");
            this.nsReg.unregister();
            this.nsReg = null;
        }
        if (this.mbeanRegistrations != null) {
            this.mbeanRegistrations.close();
            this.mbeanRegistrations = null;
        }
        if (this.observerTracker != null) {
            this.observerTracker.stop();
            this.observerTracker = null;
        }
        this.nodeStoresInUse.clear();
    }

    protected void bindNodeStore(NodeStoreProvider ns, Map<String, ?> config) throws IOException, CommitFailedException {
        NodeStoreWithProps newNs = new NodeStoreWithProps(ns, config);
        this.nodeStores.add(newNs);
        if (this.context == null) {
            LOG.info("bindNodeStore: context is null, delaying reconfiguration");
            return;
        }
        if (this.nsReg == null) {
            this.registerCompositeNodeStore();
        }
    }

    protected void unbindNodeStore(NodeStoreProvider ns) throws IOException {
        this.nodeStores.removeIf(nodeStoreWithProps -> nodeStoreWithProps.getNodeStoreProvider() == ns);
        if (this.context == null) {
            LOG.info("unbindNodeStore: context is null, delaying reconfiguration");
            return;
        }
        if (this.nsReg != null && this.nodeStoresInUse.contains(ns)) {
            this.unregisterCompositeNodeStore();
        }
    }

    protected void bindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        this.mountInfoProvider = mountInfoProvider;
    }

    protected void unbindMountInfoProvider(MountInfoProvider mountInfoProvider) {
        if (this.mountInfoProvider == mountInfoProvider) {
            this.mountInfoProvider = null;
        }
    }

    protected void bindChecks(NodeStoreChecks nodeStoreChecks) {
        this.checks = nodeStoreChecks;
    }

    protected void unbindChecks(NodeStoreChecks nodeStoreChecks) {
        if (this.checks == nodeStoreChecks) {
            this.checks = null;
        }
    }

    protected void bindStatisticsProvider(StatisticsProvider statisticsProvider) {
        this.statisticsProvider = statisticsProvider;
    }

    protected void unbindStatisticsProvider(StatisticsProvider statisticsProvider) {
        if (this.statisticsProvider == statisticsProvider) {
            this.statisticsProvider = null;
        }
    }

    private static class NodeStoreWithProps {
        private final NodeStoreProvider nodeStore;
        private final Map<String, ?> props;

        public NodeStoreWithProps(NodeStoreProvider nodeStore, Map<String, ?> props) {
            this.nodeStore = nodeStore;
            this.props = props;
        }

        public NodeStoreProvider getNodeStoreProvider() {
            return this.nodeStore;
        }

        public Map<String, ?> getProps() {
            return this.props;
        }

        public String getRole() {
            return PropertiesUtil.toString(this.props.get("role"), null);
        }

        public String getDescription() {
            return PropertiesUtil.toString(this.getProps().get("oak.nodestore.description"), this.getNodeStoreProvider().getClass().toString());
        }
    }
}

