/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite.checks;

import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.oak.api.IllegalRepositoryStateException;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.checks.MountedNodeStoreChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ErrorHolder {
    private static final int FAIL_IMMEDIATELY_THRESHOLD = 100;
    private final List<String> errors = new ArrayList<String>();
    private static final Logger log = LoggerFactory.getLogger(ErrorHolder.class);

    ErrorHolder() {
    }

    public void report(MountedNodeStore mountedStore, String path, String error, MountedNodeStoreChecker<?> checker) {
        String msg = String.format("For NodeStore mount %s, path %s, encountered the following problem: '%s' (via checker %s)", mountedStore.getMount().getName(), path, error, checker);
        log.error(msg);
        this.errors.add(msg);
        if (this.errors.size() == 100) {
            this.end();
        }
    }

    public void report(MountedNodeStore firstNS, String firstPath, MountedNodeStore secondNS, String secondPath, String value, String error, MountedNodeStoreChecker<?> checker) {
        String msg = String.format("For NodeStore mount %s, path %s, and NodeStore mount %s, path %s, encountered the following clash for value %s: '%s' (via checker %s)", firstNS.getMount().getName(), firstPath, secondNS.getMount().getName(), secondPath, value, error, checker);
        log.error(msg);
        this.errors.add(msg);
        if (this.errors.size() == 100) {
            this.end();
        }
    }

    public void end() {
        if (this.errors.isEmpty()) {
            return;
        }
        StringBuilder out = new StringBuilder();
        out.append(this.errors.size()).append(" errors were found: \n");
        this.errors.forEach(e -> out.append((String)e).append('\n'));
        throw new IllegalRepositoryStateException(out.toString());
    }
}

