/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import java.util.List;
import java.util.Map;
import org.apache.jackrabbit.guava.common.collect.ImmutableMap;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.spi.whiteboard.CompositeRegistration;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;

public class IndexMBeanRegistration
implements Registration {
    private final Whiteboard whiteboard;
    private final List<Registration> regs = Lists.newArrayList();

    public IndexMBeanRegistration(Whiteboard whiteboard) {
        this.whiteboard = whiteboard;
    }

    public void registerAsyncIndexer(AsyncIndexUpdate task, long delayInSeconds) {
        task.setIndexMBeanRegistration(this);
        ImmutableMap config = ImmutableMap.of((Object)"oak.async", (Object)task.getName(), (Object)"scheduler.name", (Object)(AsyncIndexUpdate.class.getName() + "-" + task.getName()));
        this.regs.add(WhiteboardUtils.scheduleWithFixedDelay(this.whiteboard, (Runnable)task, (Map<String, Object>)config, delayInSeconds, WhiteboardUtils.ScheduleExecutionInstanceTypes.RUN_ON_LEADER, true));
        this.regs.add(WhiteboardUtils.registerMBean(this.whiteboard, IndexStatsMBean.class, task.getIndexStats(), "IndexStats", task.getName()));
    }

    @Override
    public void unregister() {
        new CompositeRegistration(this.regs).unregister();
    }
}

