/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.AbstractIterator;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Queues;
import org.apache.jackrabbit.guava.common.collect.Sets;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Result;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.cursor.Cursors;
import org.apache.jackrabbit.oak.plugins.index.cursor.PathCursor;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexLookupUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexStatistics;
import org.apache.jackrabbit.oak.plugins.index.lucene.LucenePropertyIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneRequestFacade;
import org.apache.jackrabbit.oak.plugins.index.lucene.MultiLuceneIndex;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.MoreLikeThisHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.PathStoredFieldVisitor;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SpellcheckHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SuggestHelper;
import org.apache.jackrabbit.oak.plugins.index.search.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.search.SizeEstimator;
import org.apache.jackrabbit.oak.plugins.index.search.util.IndexHelper;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryLimits;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextContains;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.spi.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneIndex
implements QueryIndex.AdvanceFulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndex.class);
    public static final String NATIVE_QUERY_FUNCTION = "native*lucene";
    private static double MIN_COST = 2.2;
    static final String ATTR_INDEX_PATH = "oak.lucene.indexPath";
    static final int LUCENE_QUERY_BATCH_SIZE = 50;
    static final boolean USE_PATH_RESTRICTION = Boolean.getBoolean("oak.luceneUsePath");
    static final int MAX_RELOAD_COUNT = Integer.getInteger("oak.luceneMaxReloadCount", 16);
    protected final IndexTracker tracker;
    private final QueryIndex.NodeAggregator aggregator;
    private final Highlighter highlighter = new Highlighter(new SimpleHTMLFormatter("<strong>", "</strong>"), new SimpleHTMLEncoder(), null);
    private static char[] fulltextTokens = new char[]{'*', '?'};

    public LuceneIndex(IndexTracker tracker, QueryIndex.NodeAggregator aggregator) {
        this.tracker = tracker;
        this.aggregator = aggregator;
    }

    @Override
    public double getMinimumCost() {
        return MIN_COST;
    }

    @Override
    public String getIndexName() {
        return "lucene";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft == null) {
            return Collections.emptyList();
        }
        String indexPath = LuceneIndexLookupUtil.getOldFullTextIndexPath(rootState, filter, this.tracker);
        if (indexPath == null) {
            return Collections.emptyList();
        }
        Set<String> relPaths = LuceneIndex.getRelativePaths(ft);
        if (relPaths.size() > 1) {
            LOG.warn("More than one relative parent for query " + filter.getQueryStatement());
            return Collections.emptyList();
        }
        LuceneIndexNode node = this.tracker.acquireIndexNode(indexPath);
        try {
            if (node != null) {
                LuceneIndexDefinition defn = node.getDefinition();
                LuceneIndexStatistics stats = node.getIndexStatistics();
                if (stats != null) {
                    List<QueryIndex.IndexPlan> list = Collections.singletonList(LuceneIndex.planBuilder(filter).setEstimatedEntryCount(defn.getFulltextEntryCount(stats.numDocs())).setCostPerExecution(defn.getCostPerExecution()).setCostPerEntry(defn.getCostPerEntry()).setDeprecated(defn.isDeprecated()).setAttribute(ATTR_INDEX_PATH, indexPath).setDeprecated(defn.isDeprecated()).build());
                    return list;
                }
            }
            List<QueryIndex.IndexPlan> list = Collections.emptyList();
            return list;
        }
        finally {
            if (node != null) {
                node.release();
            }
        }
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        Filter filter = plan.getFilter();
        LuceneIndexNode index = this.tracker.acquireIndexNode((String)plan.getAttribute(ATTR_INDEX_PATH));
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"The Lucene index is not available");
        try {
            FullTextExpression ft = filter.getFullTextConstraint();
            Set<String> relPaths = LuceneIndex.getRelativePaths(ft);
            if (relPaths.size() > 1) {
                String string = new MultiLuceneIndex(filter, root, relPaths).getPlan();
                return string;
            }
            String parent = relPaths.size() == 0 ? "" : relPaths.iterator().next();
            boolean nonFullTextConstraints = parent.isEmpty();
            String planDesc = LuceneIndex.getLuceneRequest(filter, null, nonFullTextConstraints, index.getDefinition()) + " ft:(" + ft + ")";
            if (!parent.isEmpty()) {
                planDesc = planDesc + " parent:" + parent;
            }
            String string = planDesc;
            return string;
        }
        finally {
            index.release();
        }
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public Cursor query(final QueryIndex.IndexPlan plan, NodeState rootState) {
        Filter filter;
        FullTextExpression ft;
        Set<String> relPaths;
        if (plan.isDeprecated()) {
            LOG.warn("This index is deprecated: {}; it is used for query {}. Please change the query or the index definitions.", (Object)plan.getPlanName(), (Object)plan.getFilter());
        }
        if ((relPaths = LuceneIndex.getRelativePaths(ft = (filter = plan.getFilter()).getFullTextConstraint())).size() > 1) {
            return new MultiLuceneIndex(filter, rootState, relPaths).query();
        }
        final String parent = relPaths.size() == 0 ? "" : relPaths.iterator().next();
        final boolean nonFullTextConstraints = parent.isEmpty();
        final int parentDepth = PathUtils.getDepth(parent);
        QueryLimits settings = filter.getQueryLimits();
        LuceneResultRowIterator itr = new LuceneResultRowIterator(){
            private final Deque<LuceneResultRow> queue = Queues.newArrayDeque();
            private final Set<String> seenPaths = Sets.newHashSet();
            private ScoreDoc lastDoc;
            private int nextBatchSize = 50;
            private boolean noDocs = false;
            private long lastSearchIndexerVersion;
            private int reloadCount;

            protected LuceneResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (LuceneResultRow)this.endOfData();
            }

            @Override
            public int rewoundCount() {
                return this.reloadCount;
            }

            private LuceneResultRow convertToRow(ScoreDoc doc, IndexSearcher searcher, String excerpt) throws IOException {
                IndexReader reader = searcher.getIndexReader();
                PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                reader.document(doc.doc, visitor);
                String path = visitor.getPath();
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (!parent.isEmpty()) {
                        if (this.seenPaths.contains(path = PathUtils.getAncestorPath(path, parentDepth))) {
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    return new LuceneResultRow(path, doc.score, excerpt);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadDocs() {
                if (this.noDocs) {
                    return false;
                }
                ScoreDoc lastDocToRecord = null;
                LuceneIndexNode indexNode = LuceneIndex.this.tracker.acquireIndexNode((String)plan.getAttribute(LuceneIndex.ATTR_INDEX_PATH));
                Preconditions.checkState((indexNode != null ? 1 : 0) != 0);
                try {
                    IndexSearcher searcher = indexNode.getSearcher();
                    LuceneRequestFacade luceneRequestFacade = LuceneIndex.getLuceneRequest(filter, searcher.getIndexReader(), nonFullTextConstraints, indexNode.getDefinition());
                    if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                        Query query = (Query)luceneRequestFacade.getLuceneRequest();
                        long time = System.currentTimeMillis();
                        this.checkForIndexVersionChange(searcher);
                        while (true) {
                            TopDocs docs;
                            if (this.lastDoc != null) {
                                LOG.debug("loading the next {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = searcher.searchAfter(this.lastDoc, query, this.nextBatchSize);
                            } else {
                                LOG.debug("loading the first {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                                docs = searcher.search(query, this.nextBatchSize);
                            }
                            time = System.currentTimeMillis() - time;
                            LOG.debug("... took {} ms", (Object)time);
                            this.nextBatchSize = (int)Math.min((long)this.nextBatchSize * 2L, 100000L);
                            Filter.PropertyRestriction restriction = filter.getPropertyRestriction("rep:excerpt");
                            boolean addExcerpt = restriction != null && restriction.isNotNullRestriction();
                            Analyzer analyzer = indexNode.getDefinition().getAnalyzer();
                            if (addExcerpt) {
                                QueryScorer scorer = new QueryScorer(query);
                                scorer.setExpandMultiTermQuery(true);
                                LuceneIndex.this.highlighter.setFragmentScorer(scorer);
                            }
                            for (ScoreDoc doc : docs.scoreDocs) {
                                LuceneResultRow row;
                                String excerpt = null;
                                if (addExcerpt) {
                                    excerpt = LuceneIndex.this.getExcerpt(analyzer, searcher, doc);
                                }
                                if ((row = this.convertToRow(doc, searcher, excerpt)) != null) {
                                    this.queue.add(row);
                                }
                                lastDocToRecord = doc;
                            }
                            if (this.queue.isEmpty() && docs.scoreDocs.length > 0) {
                                this.lastDoc = lastDocToRecord;
                                continue;
                            }
                            break;
                        }
                    } else if (luceneRequestFacade.getLuceneRequest() instanceof SpellcheckHelper.SpellcheckQuery) {
                        SpellcheckHelper.SpellcheckQuery spellcheckQuery = (SpellcheckHelper.SpellcheckQuery)luceneRequestFacade.getLuceneRequest();
                        this.noDocs = true;
                        SuggestWord[] suggestWords = SpellcheckHelper.getSpellcheck(spellcheckQuery);
                        ArrayList<String> suggestedWords = new ArrayList<String>(suggestWords.length);
                        QueryParser qp = new QueryParser(Version.LUCENE_47, ":suggest", indexNode.getDefinition().getAnalyzer());
                        block7: for (SuggestWord suggestion : suggestWords) {
                            Query query = qp.createPhraseQuery(":suggest", suggestion.string);
                            TopDocs topDocs = searcher.search(query, 100);
                            if (topDocs.totalHits <= 0) continue;
                            for (ScoreDoc doc : topDocs.scoreDocs) {
                                Document retrievedDoc = searcher.doc(doc.doc);
                                if (!filter.isAccessible(retrievedDoc.get(":path"))) continue;
                                suggestedWords.add(suggestion.string);
                                continue block7;
                            }
                        }
                        this.queue.add(new LuceneResultRow(suggestedWords));
                    } else if (luceneRequestFacade.getLuceneRequest() instanceof SuggestHelper.SuggestQuery) {
                        SuggestHelper.SuggestQuery suggestQuery = (SuggestHelper.SuggestQuery)luceneRequestFacade.getLuceneRequest();
                        this.noDocs = true;
                        List<Lookup.LookupResult> lookupResults = SuggestHelper.getSuggestions(indexNode.getLookup(), suggestQuery);
                        ArrayList<String> suggestedWords = new ArrayList<String>(lookupResults.size());
                        QueryParser qp = new QueryParser(Version.LUCENE_47, ":fulltext", indexNode.getDefinition().getAnalyzer());
                        block9: for (Lookup.LookupResult suggestion : lookupResults) {
                            Query query = qp.createPhraseQuery(":fulltext", suggestion.key.toString());
                            TopDocs topDocs = searcher.search(query, 100);
                            if (topDocs.totalHits <= 0) continue;
                            for (ScoreDoc doc : topDocs.scoreDocs) {
                                Document retrievedDoc = searcher.doc(doc.doc);
                                if (!filter.isAccessible(retrievedDoc.get(":path"))) continue;
                                suggestedWords.add("{term=" + suggestion.key + ",weight=" + suggestion.value + "}");
                                continue block9;
                            }
                        }
                        this.queue.add(new LuceneResultRow(suggestedWords));
                    }
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LuceneIndex.this, (Object)e);
                }
                finally {
                    indexNode.release();
                }
                if (lastDocToRecord != null) {
                    this.lastDoc = lastDocToRecord;
                }
                return !this.queue.isEmpty();
            }

            private void checkForIndexVersionChange(IndexSearcher searcher) {
                long currentVersion = LucenePropertyIndex.getVersion(searcher);
                if (currentVersion != this.lastSearchIndexerVersion && this.lastDoc != null) {
                    ++this.reloadCount;
                    if (this.reloadCount > MAX_RELOAD_COUNT) {
                        LOG.error("More than {} index version changes detected for query {}", (Object)MAX_RELOAD_COUNT, (Object)plan);
                        throw new IllegalStateException("Too many version changes");
                    }
                    this.lastDoc = null;
                    LOG.info("Change in index version detected {} => {}. Query would be performed without offset; reload {}", currentVersion, this.lastSearchIndexerVersion, this.reloadCount);
                }
                this.lastSearchIndexerVersion = currentVersion;
            }
        };
        SizeEstimator sizeEstimator = new SizeEstimator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public long getSize() {
                LuceneIndexNode indexNode = LuceneIndex.this.tracker.acquireIndexNode((String)plan.getAttribute(LuceneIndex.ATTR_INDEX_PATH));
                Preconditions.checkState((indexNode != null ? 1 : 0) != 0);
                try {
                    IndexSearcher searcher = indexNode.getSearcher();
                    LuceneRequestFacade luceneRequestFacade = LuceneIndex.getLuceneRequest(filter, searcher.getIndexReader(), nonFullTextConstraints, indexNode.getDefinition());
                    if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                        Query query = (Query)luceneRequestFacade.getLuceneRequest();
                        TotalHitCountCollector collector = new TotalHitCountCollector();
                        searcher.search(query, collector);
                        int totalHits = collector.getTotalHits();
                        LOG.debug("Estimated size for query {} is {}", (Object)query, (Object)totalHits);
                        long l = totalHits;
                        return l;
                    }
                    LOG.debug("Estimated size: not a Query: {}", luceneRequestFacade.getLuceneRequest());
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LuceneIndex.this, (Object)e);
                }
                finally {
                    indexNode.release();
                }
                return -1L;
            }
        };
        return new LucenePathCursor(itr, settings, sizeEstimator, filter);
    }

    private String getExcerpt(Analyzer analyzer, IndexSearcher searcher, ScoreDoc doc) throws IOException {
        StringBuilder excerpt = new StringBuilder();
        for (IndexableField field : searcher.getIndexReader().document(doc.doc).getFields()) {
            String name = field.name();
            if (!name.startsWith(":fulltext") && !name.startsWith("full:")) continue;
            String text = field.stringValue();
            TokenStream tokenStream = analyzer.tokenStream(name, text);
            try {
                TextFragment[] textFragments = this.highlighter.getBestTextFragments(tokenStream, text, true, 2);
                if (textFragments == null || textFragments.length <= 0) continue;
                for (TextFragment fragment : textFragments) {
                    if (excerpt.length() > 0) {
                        excerpt.append("...");
                    }
                    excerpt.append(fragment.toString());
                }
                break;
            }
            catch (InvalidTokenOffsetsException e) {
                LOG.error("higlighting failed", e);
            }
        }
        return excerpt.toString();
    }

    protected static QueryIndex.IndexPlan.Builder planBuilder(Filter filter) {
        return new QueryIndex.IndexPlan.Builder().setCostPerExecution(0.0).setCostPerEntry(1.0).setFilter(filter).setFulltextIndex(true).setEstimatedEntryCount(0L).setIncludesNodeData(false).setDelayed(true);
    }

    private static Set<String> getRelativePaths(FullTextExpression ft) {
        if (ft == null) {
            return Collections.emptySet();
        }
        final HashSet<String> relPaths = new HashSet<String>();
        ft.accept(new FullTextVisitor.FullTextVisitorBase(){

            @Override
            public boolean visit(FullTextTerm term) {
                String p = term.getPropertyName();
                if (p == null) {
                    relPaths.add("");
                } else {
                    if (p.startsWith("../") || p.startsWith("./")) {
                        throw new IllegalArgumentException("Relative parent is not supported:" + p);
                    }
                    if (PathUtils.getDepth(p) > 1) {
                        String parent = PathUtils.getParentPath(p);
                        relPaths.add(parent);
                    } else {
                        relPaths.add("");
                    }
                }
                return true;
            }
        });
        return relPaths;
    }

    private static LuceneRequestFacade getLuceneRequest(Filter filter, IndexReader reader, boolean nonFullTextConstraints, LuceneIndexDefinition indexDefinition) {
        ArrayList<Query> qs = new ArrayList<Query>();
        Analyzer analyzer = indexDefinition.getAnalyzer();
        FullTextExpression ft = filter.getFullTextConstraint();
        if (ft != null) {
            qs.add(LuceneIndex.getFullTextQuery(ft, analyzer, reader));
        }
        Filter.PropertyRestriction pr = filter.getPropertyRestriction(NATIVE_QUERY_FUNCTION);
        if (pr != null) {
            String query = String.valueOf(pr.first.getValue(pr.first.getType()));
            QueryParser queryParser = new QueryParser(LuceneIndexConstants.VERSION, "", indexDefinition.getAnalyzer());
            if (query.startsWith("mlt?")) {
                Query moreLikeThis;
                String mltQueryString = query.replace("mlt?", "");
                if (reader != null && (moreLikeThis = MoreLikeThisHelper.getMoreLikeThis(reader, analyzer, mltQueryString)) != null) {
                    qs.add(moreLikeThis);
                }
            }
            if (query.startsWith("spellcheck?")) {
                String spellcheckQueryString = query.replace("spellcheck?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SpellcheckHelper.SpellcheckQuery>(SpellcheckHelper.getSpellcheckQuery(spellcheckQueryString, reader));
                }
            } else if (query.startsWith("suggest?")) {
                String suggestQueryString = query.replace("suggest?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SuggestHelper.SuggestQuery>(SuggestHelper.getSuggestQuery(suggestQueryString));
                }
            } else {
                try {
                    qs.add(queryParser.parse(query));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (nonFullTextConstraints) {
            LuceneIndex.addNonFullTextConstraints(qs, filter, reader, analyzer, indexDefinition);
        }
        if (qs.size() == 0) {
            return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
        }
        return LucenePropertyIndex.performAdditionalWraps(qs);
    }

    private static void addNonFullTextConstraints(List<Query> qs, Filter filter, IndexReader reader, Analyzer analyzer, IndexDefinition indexDefinition) {
        if (!filter.matchesAllTypes()) {
            LuceneIndex.addNodeTypeConstraints(qs, filter);
        }
        Object path = filter.getPath();
        switch (filter.getPathRestriction()) {
            case ALL_CHILDREN: {
                if (!USE_PATH_RESTRICTION || "/".equals(path)) break;
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                qs.add(new PrefixQuery(TermFactory.newPathTerm((String)path)));
                break;
            }
            case DIRECT_CHILDREN: {
                if (!USE_PATH_RESTRICTION) break;
                if (!((String)path).endsWith("/")) {
                    path = (String)path + "/";
                }
                qs.add(new PrefixQuery(TermFactory.newPathTerm((String)path)));
                break;
            }
            case EXACT: {
                qs.add(new TermQuery(TermFactory.newPathTerm((String)path)));
                break;
            }
            case PARENT: {
                if (PathUtils.denotesRoot((String)path)) {
                    qs.add(new TermQuery(new Term(":path", "///")));
                    break;
                }
                qs.add(new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath((String)path))));
                break;
            }
        }
        IndexDefinition.IndexingRule rule = indexDefinition.getApplicableIndexingRule("nt:base");
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            String name;
            if (pr.first == null && pr.last == null || LuceneIndex.isExcludedProperty(pr, rule) || "rep:excerpt".equals(name = pr.propertyName) || "oak:scoreExplanation".equals(name) || "rep:facet".equals(name) || "jcr:primaryType".equals(name) || ":localname".equals(name)) continue;
            if (IndexHelper.skipTokenization((String)name)) {
                qs.add(new TermQuery(new Term(name, pr.first.getValue(Type.STRING))));
                continue;
            }
            String first = null;
            String last = null;
            boolean isLike = pr.isLike;
            if (pr.first != null) {
                first = pr.first.getValue(Type.STRING);
                first = first.replace("\\", "");
            }
            if (pr.last != null) {
                last = pr.last.getValue(Type.STRING);
                last = last.replace("\\", "");
            }
            if (isLike) {
                first = first.replace('%', '*');
                first = first.replace('_', '?');
                int indexOfWS = first.indexOf(42);
                int indexOfWC = first.indexOf(63);
                int len = first.length();
                if (indexOfWS == len || indexOfWC == len) {
                    first = first.substring(0, first.length() - 1);
                    if ("jcr:path".equals(name)) {
                        qs.add(new PrefixQuery(TermFactory.newPathTerm(first)));
                        continue;
                    }
                    qs.add(new PrefixQuery(new Term(name, first)));
                    continue;
                }
                if ("jcr:path".equals(name)) {
                    qs.add(new WildcardQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                qs.add(new WildcardQuery(new Term(name, first)));
                continue;
            }
            if (first != null && first.equals(last) && pr.firstIncluding && pr.lastIncluding) {
                if ("jcr:path".equals(name)) {
                    qs.add(new TermQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                if ("*".equals(name)) {
                    LuceneIndex.addReferenceConstraint(first, qs, reader);
                    continue;
                }
                for (String t : LuceneIndex.tokenize(first, analyzer)) {
                    qs.add(new TermQuery(new Term(name, t)));
                }
                continue;
            }
            first = LuceneIndex.tokenizeAndPoll(first, analyzer);
            last = LuceneIndex.tokenizeAndPoll(last, analyzer);
            qs.add(TermRangeQuery.newStringRange(name, first, last, pr.firstIncluding, pr.lastIncluding));
        }
    }

    private static String tokenizeAndPoll(String token, Analyzer analyzer) {
        List<String> tokens;
        if (token != null && !(tokens = LuceneIndex.tokenize(token, analyzer)).isEmpty()) {
            token = tokens.get(0);
        }
        return token;
    }

    private static boolean isExcludedProperty(Filter.PropertyRestriction pr, IndexDefinition.IndexingRule rule) {
        String name = pr.propertyName;
        if (name.contains("/")) {
            return true;
        }
        PropertyDefinition pd = rule.getConfig(name);
        if (pd == null || !pd.index) {
            return true;
        }
        Integer type = null;
        if (pr.first != null) {
            type = pr.first.getType().tag();
        } else if (pr.last != null) {
            type = pr.last.getType().tag();
        } else if (pr.list != null && !pr.list.isEmpty()) {
            type = pr.list.get(0).getType().tag();
        }
        return type != null && !LuceneIndex.includePropertyType(type, rule);
    }

    private static boolean includePropertyType(int type, IndexDefinition.IndexingRule rule) {
        if (rule.propertyTypes < 0) {
            return false;
        }
        return (rule.propertyTypes & 1 << type) != 0;
    }

    private static void addReferenceConstraint(String uuid, List<Query> qs, IndexReader reader) {
        if (reader == null) {
            qs.add(new TermQuery(new Term("*", uuid)));
            return;
        }
        BooleanQuery bq = new BooleanQuery();
        Collection<String> fields = MultiFields.getIndexedFields(reader);
        for (String f : fields) {
            bq.add(new TermQuery(new Term(f, uuid)), BooleanClause.Occur.SHOULD);
        }
        qs.add(bq);
    }

    private static void addNodeTypeConstraints(List<Query> qs, Filter filter) {
        BooleanQuery bq = new BooleanQuery();
        for (String type : filter.getPrimaryTypes()) {
            bq.add(new TermQuery(new Term("jcr:primaryType", type)), BooleanClause.Occur.SHOULD);
        }
        for (String type : filter.getMixinTypes()) {
            bq.add(new TermQuery(new Term("jcr:mixinTypes", type)), BooleanClause.Occur.SHOULD);
        }
        qs.add(bq);
    }

    static Query getFullTextQuery(FullTextExpression ft, final Analyzer analyzer, final IndexReader reader) {
        final AtomicReference result = new AtomicReference();
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextContains contains) {
                return contains.getBase().accept(this);
            }

            @Override
            public boolean visit(FullTextOr or) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : or.list) {
                    Query x = LuceneIndex.getFullTextQuery(e, analyzer, reader);
                    q.add(x, BooleanClause.Occur.SHOULD);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : and.list) {
                    BooleanQuery bq;
                    Query x = LuceneIndex.getFullTextQuery(e, analyzer, reader);
                    boolean hasMustNot = false;
                    if (x instanceof BooleanQuery && (bq = (BooleanQuery)x).getClauses().length == 1 && bq.getClauses()[0].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        hasMustNot = true;
                        q.add(bq.getClauses()[0]);
                    }
                    if (hasMustNot) continue;
                    q.add(x, BooleanClause.Occur.MUST);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                return this.visitTerm(term.getPropertyName(), term.getText(), term.getBoost(), term.isNot());
            }

            private boolean visitTerm(String propertyName, String text, String boost, boolean not) {
                Query q;
                String p = propertyName;
                if (p != null && p.indexOf(47) >= 0) {
                    p = PathUtils.getName(p);
                }
                if ((q = LuceneIndex.tokenToQuery(text, p, analyzer, reader)) == null) {
                    return false;
                }
                if (boost != null) {
                    q.setBoost(Float.parseFloat(boost));
                }
                if (not) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(q, BooleanClause.Occur.MUST_NOT);
                    result.set(bq);
                } else {
                    result.set(q);
                }
                return true;
            }
        });
        return (Query)result.get();
    }

    static Query tokenToQuery(String text, String fieldName, Analyzer analyzer, IndexReader reader) {
        if (analyzer == null) {
            return null;
        }
        List<String> tokens = LuceneIndex.tokenize(text, analyzer);
        if (tokens.isEmpty()) {
            return new BooleanQuery();
        }
        if (tokens.size() == 1) {
            String token = tokens.iterator().next();
            if (LuceneIndex.hasFulltextToken(token)) {
                return new WildcardQuery(TermFactory.newFulltextTerm(token, fieldName));
            }
            return new TermQuery(TermFactory.newFulltextTerm(token, fieldName));
        }
        if (LuceneIndex.hasFulltextToken(tokens)) {
            BooleanQuery bq = new BooleanQuery();
            for (String token : tokens) {
                if (LuceneIndex.hasFulltextToken(token)) {
                    bq.add(new WildcardQuery(TermFactory.newFulltextTerm(token, fieldName)), BooleanClause.Occur.MUST);
                    continue;
                }
                bq.add(new TermQuery(TermFactory.newFulltextTerm(token, fieldName)), BooleanClause.Occur.MUST);
            }
            return bq;
        }
        PhraseQuery pq = new PhraseQuery();
        for (String t : tokens) {
            pq.add(TermFactory.newFulltextTerm(t, fieldName));
        }
        return pq;
    }

    private static boolean hasFulltextToken(List<String> tokens) {
        for (String token : tokens) {
            if (!LuceneIndex.hasFulltextToken(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFulltextToken(String token) {
        for (char c : fulltextTokens) {
            if (token.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> tokenize(String text, Analyzer analyzer) {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream stream = null;
        try {
            stream = analyzer.tokenStream(":fulltext", new StringReader(text));
            CharTermAttribute termAtt = stream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            int poz = 0;
            boolean hasFulltextToken = false;
            StringBuilder token = new StringBuilder();
            while (stream.incrementToken()) {
                String term = termAtt.toString();
                int start = offsetAtt.startOffset();
                int end = offsetAtt.endOffset();
                if (start > poz) {
                    for (int i = poz; i < start; ++i) {
                        for (char c : fulltextTokens) {
                            if (c != text.charAt(i)) continue;
                            token.append(c);
                            hasFulltextToken = true;
                        }
                    }
                }
                poz = end;
                if (hasFulltextToken) {
                    token.append(term);
                    hasFulltextToken = false;
                    continue;
                }
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token = new StringBuilder();
                token.append(term);
            }
            if (poz < text.length()) {
                for (int i = poz; i < text.length(); ++i) {
                    for (char c : fulltextTokens) {
                        if (c != text.charAt(i)) continue;
                        token.append(c);
                    }
                }
            }
            if (token.length() > 0) {
                tokens.add(token.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            LOG.error("Building fulltext query failed", (Object)e.getMessage());
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return tokens;
    }

    @Override
    public QueryIndex.NodeAggregator getNodeAggregator() {
        return this.aggregator;
    }

    static abstract class LuceneResultRowIterator
    extends AbstractIterator<LuceneResultRow> {
        LuceneResultRowIterator() {
        }

        abstract int rewoundCount();
    }

    static class LucenePathCursor
    implements Cursor {
        private final int TRAVERSING_WARNING = Integer.getInteger("oak.traversing.warning", 10000);
        private final Cursor pathCursor;
        LuceneResultRow currentRow;
        private final SizeEstimator sizeEstimator;
        private long estimatedSize;

        LucenePathCursor(final LuceneResultRowIterator it, final QueryLimits settings, SizeEstimator sizeEstimator, final Filter filter) {
            this.sizeEstimator = sizeEstimator;
            Iterator<String> pathIterator = new Iterator<String>(){
                private int readCount;
                private int rewoundCount;

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    if (it.rewoundCount() > this.rewoundCount) {
                        this.readCount = 0;
                        this.rewoundCount = it.rewoundCount();
                    }
                    currentRow = (LuceneResultRow)it.next();
                    ++this.readCount;
                    if (this.readCount % TRAVERSING_WARNING == 0) {
                        Cursors.checkReadLimit((long)this.readCount, (QueryLimits)settings);
                        if (this.readCount == 2 * TRAVERSING_WARNING) {
                            LOG.warn("Index-Traversed {} nodes with filter {}", this.readCount, filter, new Exception("call stack"));
                        } else {
                            LOG.warn("Index-Traversed {} nodes with filter {}", (Object)this.readCount, (Object)filter);
                        }
                    }
                    return currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new PathCursor((Iterator)pathIterator, true, settings);
        }

        @Override
        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        @Override
        public void remove() {
            this.pathCursor.remove();
        }

        @Override
        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                @Override
                public boolean isVirtualRow() {
                    return currentRow.isVirtual;
                }

                @Override
                public String getPath() {
                    return pathRow.getPath();
                }

                @Override
                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble(currentRow.score);
                    }
                    if ("rep:spellcheck()".equals(columnName) || "rep:suggest()".equals(columnName)) {
                        return PropertyValues.newString(Iterables.toString(currentRow.suggestWords));
                    }
                    if ("rep:excerpt".equals(columnName)) {
                        return PropertyValues.newString(currentRow.excerpt);
                    }
                    return pathRow.getValue(columnName);
                }
            };
        }

        @Override
        public long getSize(Result.SizePrecision precision, long max) {
            if (this.estimatedSize != 0L) {
                return this.estimatedSize;
            }
            this.estimatedSize = this.sizeEstimator.getSize();
            return this.estimatedSize;
        }
    }

    static class LuceneResultRow {
        final String path;
        final double score;
        final Iterable<String> suggestWords;
        final boolean isVirtual;
        final String excerpt;

        LuceneResultRow(String path, double score, String excerpt) {
            this.isVirtual = false;
            this.path = path;
            this.score = score;
            this.excerpt = excerpt;
            this.suggestWords = Collections.emptySet();
        }

        LuceneResultRow(Iterable<String> suggestWords) {
            this.isVirtual = true;
            this.path = "/";
            this.score = 1.0;
            this.suggestWords = suggestWords;
            this.excerpt = null;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

