/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration;

import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.guava.common.collect.ImmutableSet;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.migration.FilteringNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStateCopier {
    private static final Logger LOG = LoggerFactory.getLogger(NodeStateCopier.class);
    private final Set<String> includePaths;
    private final Set<String> excludePaths;
    private final Set<String> fragmentPaths;
    private final Set<String> excludeFragments;
    private final Set<String> mergePaths;
    private final boolean referenceableFrozenNodes;
    private final boolean preserveOnTarget;
    private final Consumer<String> newNodesConsumer;

    private NodeStateCopier(Set<String> includePaths, Set<String> excludePaths, Set<String> fragmentPaths, Set<String> excludeFragments, Set<String> mergePaths, boolean referenceableFrozenNodes, boolean preserveOnTarget, Consumer<String> newNodesConsumer) {
        this.includePaths = includePaths;
        this.excludePaths = excludePaths;
        this.fragmentPaths = fragmentPaths;
        this.excludeFragments = excludeFragments;
        this.mergePaths = mergePaths;
        this.referenceableFrozenNodes = referenceableFrozenNodes;
        this.preserveOnTarget = preserveOnTarget;
        this.newNodesConsumer = newNodesConsumer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean copyNodeStore(@NotNull NodeStore source, @NotNull NodeStore target) throws CommitFailedException {
        return NodeStateCopier.builder().copy((NodeStore)Preconditions.checkNotNull((Object)source), (NodeStore)Preconditions.checkNotNull((Object)target));
    }

    public static boolean copyProperties(NodeState source, NodeBuilder target, boolean preserveOnTarget, String path) {
        boolean hasChanges = false;
        if (!preserveOnTarget) {
            for (PropertyState propertyState : target.getProperties()) {
                String name = propertyState.getName();
                if (source.hasProperty(name)) continue;
                target.removeProperty(name);
                hasChanges = true;
            }
        }
        for (PropertyState propertyState : source.getProperties()) {
            if (propertyState.equals(target.getProperty(propertyState.getName())) || NodeStateCopier.isVersionPropertyEmpty(source, propertyState, preserveOnTarget, path)) continue;
            target.setProperty(propertyState);
            hasChanges = true;
        }
        return hasChanges;
    }

    private static Set<String> getValues(NodeState nodeState, String prop) {
        PropertyState ps = nodeState.getProperty(prop);
        if (ps != null) {
            Iterable<String> values = ps.getValue(Type.STRINGS);
            return StreamSupport.stream(values.spliterator(), false).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private static boolean isVersionPropertyEmpty(NodeState source, PropertyState property, boolean preserveOnTarget, String path) {
        if (preserveOnTarget && (property.getName().equals("jcr:uuid") || property.getName().equals("jcr:successors") || property.getName().equals("jcr:predecessors"))) {
            boolean versionPropertyEmpty = NodeStateCopier.getValues(source, property.getName()).isEmpty();
            if (versionPropertyEmpty) {
                LOG.info("Version Property {} will be skipped for path {}", (Object)property.getName(), (Object)path);
            } else {
                LOG.info("Version Property {} will be changed for path {}", (Object)property.getName(), (Object)path);
            }
            return versionPropertyEmpty;
        }
        return false;
    }

    public static boolean copyProperties(NodeState source, NodeBuilder target) {
        return NodeStateCopier.copyProperties(source, target, false, "");
    }

    private boolean copyNodeState(@NotNull NodeState sourceRoot, @NotNull NodeBuilder targetRoot) {
        NodeState wrappedSource = FilteringNodeState.wrap("/", sourceRoot, this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments, this.referenceableFrozenNodes);
        boolean hasChanges = false;
        for (String includePath : this.includePaths) {
            boolean bl = hasChanges = NodeStateCopier.copyMissingAncestors(sourceRoot, targetRoot, includePath) || hasChanges;
            NodeState sourceState = NodeStateUtils.getNode(wrappedSource, includePath);
            if (!sourceState.exists()) continue;
            NodeBuilder targetBuilder = NodeStateCopier.getChildNodeBuilder(targetRoot, includePath);
            hasChanges = NodeStateCopier.copyNodeState(sourceState, targetBuilder, includePath, this.mergePaths, this.preserveOnTarget, this.newNodesConsumer) || hasChanges;
        }
        return hasChanges;
    }

    private static boolean copyNodeState(@NotNull NodeState source, @NotNull NodeBuilder target, @NotNull String currentPath, @NotNull Set<String> mergePaths, boolean preserveOnTarget, Consumer newNodesConsumer) {
        boolean hasChanges = false;
        for (String string : target.getChildNodeNames()) {
            if (preserveOnTarget || source.hasChildNode(string) || NodeStateCopier.isMerge(PathUtils.concat(currentPath, string), mergePaths)) continue;
            target.setChildNode(string, EmptyNodeState.MISSING_NODE);
            hasChanges = true;
        }
        for (ChildNodeEntry childNodeEntry : source.getChildNodeEntries()) {
            String childName = childNodeEntry.getName();
            NodeState childSource = childNodeEntry.getNodeState();
            String childPath = PathUtils.concat(currentPath, childName);
            if (!target.hasChildNode(childName)) {
                target.setChildNode(childName, childSource);
                newNodesConsumer.accept(childPath);
                hasChanges = true;
                continue;
            }
            NodeBuilder childTarget = target.getChildNode(childName);
            hasChanges = NodeStateCopier.copyNodeState(childSource, childTarget, childPath, mergePaths, preserveOnTarget, newNodesConsumer) || hasChanges;
        }
        boolean bl = hasChanges = NodeStateCopier.copyProperties(source, target, preserveOnTarget, currentPath) || hasChanges;
        if (hasChanges) {
            LOG.trace("Node {} has changes", (Object)target);
        }
        return hasChanges;
    }

    private static boolean isMerge(String path, Set<String> mergePaths) {
        for (String mergePath : mergePaths) {
            if (!PathUtils.isAncestor(mergePath, path) && !mergePath.equals(path)) continue;
            return true;
        }
        return false;
    }

    private static boolean copyMissingAncestors(NodeState sourceRoot, NodeBuilder targetRoot, String path) {
        NodeState current = sourceRoot;
        NodeBuilder currentBuilder = targetRoot;
        boolean hasChanges = false;
        for (String name : PathUtils.elements(path)) {
            if (!current.hasChildNode(name)) continue;
            boolean targetHasChild = currentBuilder.hasChildNode(name);
            current = current.getChildNode(name);
            currentBuilder = currentBuilder.child(name);
            if (targetHasChild) continue;
            hasChanges = NodeStateCopier.copyProperties(current, currentBuilder) || hasChanges;
        }
        return hasChanges;
    }

    @NotNull
    private static NodeBuilder getChildNodeBuilder(@NotNull NodeBuilder root, @NotNull String path) {
        NodeBuilder child = root;
        for (String name : PathUtils.elements(path)) {
            child = child.child(name);
        }
        return child;
    }

    public static class Builder {
        private Set<String> includePaths = ImmutableSet.of((Object)"/");
        private Set<String> excludePaths = Collections.emptySet();
        private Set<String> fragmentPaths = Collections.emptySet();
        private Set<String> excludeFragments = Collections.emptySet();
        private Set<String> mergePaths = Collections.emptySet();
        private boolean referenceableFrozenNodes = true;
        private boolean preserveOnTarget;
        private Consumer<String> newNodesConsumer = path -> {};

        private Builder() {
        }

        @NotNull
        public Builder include(@NotNull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.includePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder include(String ... paths) {
            return this.include((Set<String>)ImmutableSet.copyOf((Object[])((String[])Preconditions.checkNotNull((Object)paths))));
        }

        @NotNull
        public Builder preserve(@NotNull boolean preserveOnTarget) {
            this.preserveOnTarget = preserveOnTarget;
            return this;
        }

        @NotNull
        public Builder exclude(@NotNull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.excludePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder exclude(String ... paths) {
            return this.exclude((Set<String>)ImmutableSet.copyOf((Object[])((String[])Preconditions.checkNotNull((Object)paths))));
        }

        @NotNull
        public Builder supportFragment(@NotNull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.fragmentPaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder supportFragment(String ... paths) {
            return this.supportFragment((Set<String>)ImmutableSet.copyOf((Object[])((String[])Preconditions.checkNotNull((Object)paths))));
        }

        @NotNull
        public Builder excludeFragments(@NotNull Set<String> fragments) {
            if (!((Set)Preconditions.checkNotNull(fragments)).isEmpty()) {
                this.excludeFragments = ImmutableSet.copyOf(fragments);
            }
            return this;
        }

        @NotNull
        public Builder excludeFragments(String ... fragments) {
            return this.exclude((Set<String>)ImmutableSet.copyOf((Object[])((String[])Preconditions.checkNotNull((Object)fragments))));
        }

        @NotNull
        public Builder merge(@NotNull Set<String> paths) {
            if (!((Set)Preconditions.checkNotNull(paths)).isEmpty()) {
                this.mergePaths = ImmutableSet.copyOf(paths);
            }
            return this;
        }

        @NotNull
        public Builder merge(String ... paths) {
            return this.merge((Set<String>)ImmutableSet.copyOf((Object[])((String[])Preconditions.checkNotNull((Object)paths))));
        }

        @NotNull
        public Builder withReferenceableFrozenNodes(boolean isReferenceable) {
            this.referenceableFrozenNodes = isReferenceable;
            return this;
        }

        public Builder withNodeConsumer(@NotNull Consumer consumer) {
            this.newNodesConsumer = consumer;
            return this;
        }

        public boolean copy(@NotNull NodeState sourceRoot, @NotNull NodeBuilder targetRoot) {
            NodeStateCopier copier = new NodeStateCopier(this.includePaths, this.excludePaths, this.fragmentPaths, this.excludeFragments, this.mergePaths, this.referenceableFrozenNodes, this.preserveOnTarget, this.newNodesConsumer);
            return copier.copyNodeState((NodeState)Preconditions.checkNotNull((Object)sourceRoot), (NodeBuilder)Preconditions.checkNotNull((Object)targetRoot));
        }

        public boolean copy(@NotNull NodeStore source, @NotNull NodeStore target) throws CommitFailedException {
            NodeBuilder targetRoot = ((NodeStore)Preconditions.checkNotNull((Object)target)).getRoot().builder();
            if (this.copy(((NodeStore)Preconditions.checkNotNull((Object)source)).getRoot(), targetRoot)) {
                target.merge(targetRoot, EmptyHook.INSTANCE, CommitInfo.EMPTY);
                return true;
            }
            return false;
        }
    }
}

