/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.version;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import org.apache.jackrabbit.guava.common.base.Preconditions;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.plugins.tree.factories.TreeFactory;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReadOnlyVersionManager {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyVersionManager.class);

    @NotNull
    protected abstract Tree getVersionStorage();

    @NotNull
    protected abstract Root getWorkspaceRoot();

    @NotNull
    protected abstract ReadOnlyNodeTypeManager getNodeTypeManager();

    @NotNull
    public static ReadOnlyVersionManager getInstance(final Root root, final NamePathMapper namePathMapper) {
        return new ReadOnlyVersionManager(){

            @Override
            @NotNull
            protected Tree getVersionStorage() {
                return root.getTree("/jcr:system/jcr:versionStorage");
            }

            @Override
            @NotNull
            protected Root getWorkspaceRoot() {
                return root;
            }

            @Override
            @NotNull
            protected ReadOnlyNodeTypeManager getNodeTypeManager() {
                return ReadOnlyNodeTypeManager.getInstance(root, namePathMapper);
            }
        };
    }

    public boolean isCheckedOut(@NotNull Tree tree) {
        PropertyState p = tree.getProperty("jcr:isCheckedOut");
        if (p != null) {
            return p.getValue(Type.BOOLEAN);
        }
        if (tree.isRoot()) {
            return true;
        }
        return this.isCheckedOut(tree.getParent());
    }

    @Nullable
    public Tree getVersionHistory(@NotNull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        String uuid = versionable.getProperty("jcr:uuid").getValue(Type.STRING);
        return TreeUtil.getTree(this.getVersionStorage(), this.getVersionHistoryPath(uuid));
    }

    @Nullable
    public Tree getVersion(@NotNull String uuid) {
        return this.getIdentifierManager().getTree(uuid);
    }

    @NotNull
    public String getVersionHistoryPath(@NotNull String uuid) {
        String relPath = "";
        for (int i = 0; i < 3; ++i) {
            String name = uuid.substring(i * 2, i * 2 + 2);
            relPath = PathUtils.concat(relPath, name);
        }
        return PathUtils.concat(relPath, uuid);
    }

    @Nullable
    public Tree getBaseVersion(@NotNull Tree versionable) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.checkVersionable(versionable);
        PropertyState p = versionable.getProperty("jcr:baseVersion");
        if (p == null) {
            return null;
        }
        return this.getIdentifierManager().getTree(p.getValue(Type.STRING));
    }

    public static boolean isVersionStoreTree(@NotNull Tree tree) {
        return "rep:versionStorage".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    @Nullable
    public Tree getVersionable(@NotNull Tree versionTree, @NotNull String workspaceName) {
        Root root = this.getWorkspaceRoot();
        String relPath = "";
        Tree t = versionTree;
        while (t.exists() && !ReadOnlyVersionManager.isVersionStoreTree(t) && !t.isRoot()) {
            String ntName = TreeUtil.getPrimaryTypeName(t);
            if ("nt:frozenNode".equals(ntName)) {
                relPath = PathUtils.relativize(t.getPath(), versionTree.getPath());
            } else if ("nt:versionHistory".equals(ntName)) {
                PropertyState prop = t.getProperty(workspaceName);
                if (prop != null) {
                    return root.getTree(PathUtils.concat(prop.getValue(Type.PATH), relPath));
                }
                log.warn("Missing versionable path property for {} at {}", (Object)workspaceName, (Object)t.getPath());
                break;
            }
            t = t.getParent();
        }
        return null;
    }

    protected IdentifierManager getIdentifierManager() {
        return new IdentifierManager(this.getWorkspaceRoot());
    }

    @NotNull
    protected Tree checkVersionable(@NotNull Tree tree) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isVersionable((Tree)Preconditions.checkNotNull((Object)tree))) {
            throw new UnsupportedRepositoryOperationException("Node at " + tree.getPath() + " is not versionable");
        }
        return tree;
    }

    protected boolean isVersionable(@NotNull Tree tree) {
        return this.getNodeTypeManager().isNodeType((Tree)Preconditions.checkNotNull((Object)tree), "mix:versionable");
    }

    boolean isVersionable(NodeState versionableCandidate) {
        return this.isVersionable(TreeFactory.createReadOnlyTree(versionableCandidate));
    }
}

