/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public final class DrillDownQuery
extends Query {
    private final FacetsConfig config;
    private final BooleanQuery query;
    private final Map<String, Integer> drillDownDims = new LinkedHashMap<String, Integer>();

    public static Term term(String field, String dim, String ... path) {
        return new Term(field, FacetsConfig.pathToString(dim, path));
    }

    DrillDownQuery(FacetsConfig config, BooleanQuery query, Map<String, Integer> drillDownDims) {
        this.query = query.clone();
        this.drillDownDims.putAll(drillDownDims);
        this.config = config;
    }

    DrillDownQuery(FacetsConfig config, Filter filter, DrillDownQuery other) {
        this.query = new BooleanQuery(true);
        BooleanClause[] clauses = other.query.getClauses();
        if (clauses.length == other.drillDownDims.size()) {
            throw new IllegalArgumentException("cannot apply filter unless baseQuery isn't null; pass ConstantScoreQuery instead");
        }
        assert (clauses.length == 1 + other.drillDownDims.size()) : clauses.length + " vs " + (1 + other.drillDownDims.size());
        this.drillDownDims.putAll(other.drillDownDims);
        this.query.add(new FilteredQuery(clauses[0].getQuery(), filter), BooleanClause.Occur.MUST);
        for (int i = 1; i < clauses.length; ++i) {
            this.query.add(clauses[i].getQuery(), BooleanClause.Occur.MUST);
        }
        this.config = config;
    }

    DrillDownQuery(FacetsConfig config, Query baseQuery, List<Query> clauses, Map<String, Integer> drillDownDims) {
        this.query = new BooleanQuery(true);
        if (baseQuery != null) {
            this.query.add(baseQuery, BooleanClause.Occur.MUST);
        }
        for (Query clause : clauses) {
            this.query.add(clause, BooleanClause.Occur.MUST);
        }
        this.drillDownDims.putAll(drillDownDims);
        this.config = config;
    }

    public DrillDownQuery(FacetsConfig config) {
        this(config, null);
    }

    public DrillDownQuery(FacetsConfig config, Query baseQuery) {
        this.query = new BooleanQuery(true);
        if (baseQuery != null) {
            this.query.add(baseQuery, BooleanClause.Occur.MUST);
        }
        this.config = config;
    }

    private void merge(String dim, String[] path) {
        ConstantScoreQuery q;
        int index = this.drillDownDims.get(dim);
        if (this.query.getClauses().length == this.drillDownDims.size() + 1) {
            ++index;
        }
        if (!((q = (ConstantScoreQuery)this.query.clauses().get(index).getQuery()).getQuery() instanceof BooleanQuery)) {
            throw new RuntimeException("cannot merge with custom Query");
        }
        String indexedField = this.config.getDimConfig((String)dim).indexFieldName;
        BooleanQuery bq = (BooleanQuery)q.getQuery();
        bq.add(new TermQuery(DrillDownQuery.term(indexedField, dim, path)), BooleanClause.Occur.SHOULD);
    }

    public void add(String dim, String ... path) {
        if (this.drillDownDims.containsKey(dim)) {
            this.merge(dim, path);
            return;
        }
        String indexedField = this.config.getDimConfig((String)dim).indexFieldName;
        BooleanQuery bq = new BooleanQuery(true);
        bq.add(new TermQuery(DrillDownQuery.term(indexedField, dim, path)), BooleanClause.Occur.SHOULD);
        this.add(dim, bq);
    }

    public void add(String dim, Query subQuery) {
        if (this.drillDownDims.containsKey(dim)) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" already has a drill-down");
        }
        ConstantScoreQuery drillDownQuery = new ConstantScoreQuery(subQuery);
        drillDownQuery.setBoost(0.0f);
        this.query.add(drillDownQuery, BooleanClause.Occur.MUST);
        this.drillDownDims.put(dim, this.drillDownDims.size());
    }

    public void add(String dim, Filter subFilter) {
        if (this.drillDownDims.containsKey(dim)) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" already has a drill-down");
        }
        ConstantScoreQuery drillDownQuery = new ConstantScoreQuery(subFilter);
        drillDownQuery.setBoost(0.0f);
        this.query.add(drillDownQuery, BooleanClause.Occur.MUST);
        this.drillDownDims.put(dim, this.drillDownDims.size());
    }

    static Filter getFilter(Query query) {
        if (query instanceof ConstantScoreQuery) {
            ConstantScoreQuery csq = (ConstantScoreQuery)query;
            Filter filter = csq.getFilter();
            if (filter != null) {
                return filter;
            }
            return DrillDownQuery.getFilter(csq.getQuery());
        }
        return null;
    }

    @Override
    public DrillDownQuery clone() {
        return new DrillDownQuery(this.config, this.query, this.drillDownDims);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        return 31 * result + this.query.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DrillDownQuery)) {
            return false;
        }
        DrillDownQuery other = (DrillDownQuery)obj;
        return this.query.equals(other.query) && super.equals(other);
    }

    @Override
    public Query rewrite(IndexReader r) throws IOException {
        Query wrapped;
        int startIndex;
        Query baseQuery;
        if (this.query.clauses().size() == 0) {
            return new MatchAllDocsQuery();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        ArrayList<Query> queries = new ArrayList<Query>();
        List<BooleanClause> clauses = this.query.clauses();
        if (this.drillDownDims.size() == this.query.clauses().size()) {
            baseQuery = new MatchAllDocsQuery();
            startIndex = 0;
        } else {
            baseQuery = clauses.get(0).getQuery();
            startIndex = 1;
        }
        for (int i = startIndex; i < clauses.size(); ++i) {
            BooleanClause clause = clauses.get(i);
            Query queryClause = clause.getQuery();
            Filter filter = DrillDownQuery.getFilter(queryClause);
            if (filter != null) {
                filters.add(filter);
                continue;
            }
            queries.add(queryClause);
        }
        if (filters.isEmpty()) {
            return this.query;
        }
        if (queries.isEmpty()) {
            wrapped = baseQuery;
        } else {
            BooleanQuery wrappedBQ = new BooleanQuery(true);
            if (!(baseQuery instanceof MatchAllDocsQuery)) {
                wrappedBQ.add(baseQuery, BooleanClause.Occur.MUST);
            }
            for (Query q : queries) {
                wrappedBQ.add(q, BooleanClause.Occur.MUST);
            }
            wrapped = wrappedBQ;
        }
        for (Filter filter : filters) {
            wrapped = new FilteredQuery(wrapped, filter, FilteredQuery.QUERY_FIRST_FILTER_STRATEGY);
        }
        return wrapped;
    }

    @Override
    public String toString(String field) {
        return this.query.toString(field);
    }

    BooleanQuery getBooleanQuery() {
        return this.query;
    }

    Map<String, Integer> getDims() {
        return this.drillDownDims;
    }
}

