/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2016 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 **************************************************************************/
package com.adobe.cq.sites.ui.renderconditions;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.day.cq.security.util.CqActions;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.Template;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import java.io.IOException;
import java.util.Collection;

@Component(
        service = {Servlet.class},
        property = {
                "sling.servlet.resourceTypes=cq/gui/components/renderconditions/canedittemplate",
                "sling.servlet.methods=GET"
        }
)
/*
 * A condition to determine if the resource at a given path has an editable template and that the user can edit it.
 */
public class CanEditTemplateRenderCondition extends SlingSafeMethodsServlet {

    private final Logger log = LoggerFactory.getLogger(CanEditTemplateRenderCondition.class);

    @Reference
    private ExpressionResolver expressionResolver;

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response)
            throws ServletException, IOException {

        if (expressionResolver == null) {
            return;
        }

        final ResourceResolver resourceResolver = request.getResourceResolver();

        final ExpressionHelper ex = new ExpressionHelper(expressionResolver, request);
        final Config rcCfg = new Config(request.getResource());
        final String path = ex.getString(rcCfg.get("path", String.class));

        boolean canEditTemplate = false;
        Page targetPage = null;

        if (path != null) {
            Resource pageResource = resourceResolver.resolve(path);
            targetPage = pageResource.adaptTo(Page.class);
        }

        if (targetPage != null) {
            Template template = targetPage.getTemplate();

            if (template != null && template.hasStructureSupport()) {
                try {
                    Session session = resourceResolver.adaptTo(Session.class);
                    // Test the modify permission from allowed actions
                    CqActions cqActions = new CqActions(session);
                    Collection<String> allowedActions = cqActions.getAllowedActions(template.getPath(), null);
                    canEditTemplate = allowedActions.contains("modify");
                } catch (RepositoryException e) {
                    log.error("Unable to retrieve allowed user actions", e);
                }
            }
        }

        request.setAttribute(RenderCondition.class.getName(), new SimpleRenderCondition(canEditTemplate));
    }

}
