/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2001-2002, Adobe Systems Incorporated                        */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/
package com.adobe.versioncue.nativecomm;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public interface INativeService
{
	/**
	 * Creates an IRequest object to be executed by the NativeService.
	 * 
	 * @param call NativeService call name
	 * @return IRequest object
	 */
	IRequest request(String call);

	/** Dispose the service */
	void dispose();

	/**
	 * True if the INativeService instance is valid
	 * 
	 * @return true if the INativeService instance is valid
	 */
	boolean isValid();

	/**
	 * Returns the current pool size of the NativeService.
	 * 
	 * @return the current pool size of the NativeService.
	 */
	int poolSize();

	/**
	 * Returns the maximum pool size the NativeService.
	 * 
	 * @return the maximum pool size the NativeService.
	 */
	int maxConnections();

	/**
	 * Returns the total number of requests handled by this pool.
	 * 
	 * @return the total number of requests handled by this pool
	 */
	int totalRequests();

	/**
	 * Returns the string id of this NativeService.
	 * 
	 * @return string id of this NativeService
	 */
	String id();

	/**
	 * Prestarts a process connection.
	 * 
	 * Connections are usually initiated lazily on first request. This method forces a connection
	 * to be established without sending a request.
	 *
	 * @throws NativeCommException on failure
	 */
	void prestartConnection() throws NativeCommException;
}
