/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * This class contains all the script functionality associated with the
 * EventPseudoModel class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class EventPseudoModelScript extends PseudoModelScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ObjScript.moScriptTable,
		"eventPseudoModel", 
		new ScriptPropObj[] {
			new	ScriptPropObj(EventPseudoModelScript.class, "prevText" , 	  	"getPrevText" , 	  "setPrevText", 		Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_PREVTEXT_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "prevContentType",  "getPrevContentType", "setPrevContentType", Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_PREVCONTENTTYPE_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "newText", 		  	"getNewText", 		  "setNewText", 		Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_NEWTEXT_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "newContentType",   "getNewContentType",  "setNewContentType",  Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_NEWCONTENTTYPE_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "fullText", 		"getFullText", 		  "setFullText", 		Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_FULLTEXT_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "change", 	 	  	"getChangeText", 	  "setChangeText", 	  	Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_CHANGETEXT_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "commitKey", 	  	"getCommitKey", 	  "setCommitKey", 	  	Arg.INTEGER, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_COMMITKEY_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "keyDown", 		  	"getKeyDown", 		  "setKeyDown", 		Arg.BOOL, 		Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_KEYDOWN_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "modifier", 		"getModifier", 		  "setModifier", 		Arg.BOOL,		Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_MODIFIER_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "name", 			"getName", 			  "setName", 			Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_NAME_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "selEnd", 		  	"getSelEnd", 		  "setSelEnd", 		  	Arg.INTEGER, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_SELEND_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "selStart", 		"getSelStart", 		  "setSelStart", 		Arg.INTEGER, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_SELSTART_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "shift",			"getShift",			  "setShift",			Arg.BOOL, 		Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_SHIFT_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "target",		  	"getTarget",		  "setTarget",		  	Arg.OBJECT, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_TARGET_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "soapFaultCode",	"getSOAPFaultCode",	  "setSOAPFaultCode",	Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_SOAPFAULTCODE_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "soapFaultString",  "getSOAPFaultString", "setSOAPFaultString", Arg.STRING, 	Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_SOAPFAULTSTRING_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "reenter",		  	"getReenter",		  "setReenter",		  	Arg.BOOL, 		Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_REENTER_DESC,0 */, 0),
			new ScriptPropObj(EventPseudoModelScript.class, "cancelAction",		"getCancelAction",	  "setCancelAction",	Arg.BOOL,		Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_CANCELACTION_DESC,0 */, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(EventPseudoModelScript.class, "emit",  "emit",  Arg.EMPTY, new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_EMIT_DESC, 0, NULL */, 0),
			new ScriptFuncObj(EventPseudoModelScript.class, "reset", "reset", Arg.EMPTY, new int[] {}, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_EVENT_RESET_DESC, 0, NULL */, 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
	
	// ************ Script Properties **************

	public static void getPrevText(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getPrevText());
	}
	
	public static void setPrevText(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setPrevText(arg.getString());
	}

	public static void getPrevContentType(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getPrevContentType());
	}
	
	public static void setPrevContentType(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setPrevContentType(arg.getString());
	}

	public static void getNewText(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getNewText());
	}
	
	public static void setNewText(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setNewText(arg.getString());
	}

	public static void getNewContentType(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getNewContentType());
	}
	
	public static void setNewContentType(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setNewContentType(arg.getString());
	}

	public static void getFullText(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getFullText());
	}
	
	public static void setFullText(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setFullText(arg.getString());
	}

	public static void getChangeText(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getChange());
	}
	
	public static void setChangeText(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setChange(arg.getString());
	}

	public static void getCommitKey(Obj obj, Arg retVal) {
		retVal.setInteger(Integer.valueOf(((EventPseudoModel)obj).getCommitKey()));
	}
	
	public static void setCommitKey(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setCommitKey(arg.getInteger().intValue());
	}

	public static void getKeyDown(Obj obj, Arg retVal) {
		retVal.setBool(Boolean.valueOf(((EventPseudoModel)obj).getKeyDown()));
	}
	
	public static void setKeyDown(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setKeyDown(arg.getBool().booleanValue());
	}

	public static void getModifier(Obj obj, Arg retVal) {
		retVal.setBool(Boolean.valueOf(((EventPseudoModel)obj).getModifier()));
	}
	
	public static void setModifier(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setModifier(arg.getBool().booleanValue());
	}

	public static void getName(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getNameAsString());
	}
	
	public static void setName(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setName(arg.getString());
	}

	public static void getSelEnd(Obj obj, Arg retVal) {
		retVal.setInteger(Integer.valueOf(((EventPseudoModel)obj).getSelEnd()));
	}
	
	public static void setSelEnd(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setSelEnd(arg.getInteger().intValue());
	}

	public static void getSelStart(Obj obj, Arg retVal) {
		retVal.setInteger(Integer.valueOf(((EventPseudoModel)obj).getSelStart()));
	}
	
	public static void setSelStart(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setSelStart(arg.getInteger().intValue());
	}
	
	public static void getShift(Obj obj, Arg retVal) {
		retVal.setBool(Boolean.valueOf(((EventPseudoModel)obj).getShift()));
	}
	
	public static void setShift(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setShift(arg.getBool().booleanValue());
	}
	
	public static void getTarget(Obj obj, Arg retVal) {
		retVal.setObject(((EventPseudoModel)obj).getTarget());
	}
	
	public static void setTarget(Obj obj, Arg arg) {
		// check object type
		Obj oObject = arg.getObject();
//		if (!(oObject instanceof Obj))
//			throw new ExFull(ResId.ArgumentMismatchException);

		((EventPseudoModel)obj).setTarget(oObject);
	}
	
	public static void getSOAPFaultCode(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getSOAPFaultCode());
	}
	
	public static void setSOAPFaultCode(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setSOAPFaultCode(arg.getString());
	}

	public static void getSOAPFaultString(Obj obj, Arg retVal) {
		retVal.setString(((EventPseudoModel)obj).getSOAPFaultString());
	}
	
	public static void setSOAPFaultString(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setSOAPFaultString(arg.getString());
	}
	
	public static void getReenter(Obj obj, Arg retVal) {
		retVal.setBool(Boolean.valueOf(((EventPseudoModel)obj).getReenter()));
	}
	
	public static void setReenter(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setReenter(arg.getBool().booleanValue());
	}
	
	public static void getCancelAction(Obj obj, Arg retVal) {
		retVal.setBool(((EventPseudoModel)obj).getCancelAction());
	}
	
	public static void setCancelAction(Obj obj, Arg arg) {
		((EventPseudoModel)obj).setCancelAction(arg.getBool(), null);
	}
	
	// ************ Script Functions **************

	public static void emit(Obj obj, Arg retVal, Arg[] args) {
		((EventPseudoModel)obj).emit();
	}
	
	public static void reset(Obj obj, Arg retVal, Arg[] args) {
		((EventPseudoModel)obj).reset();
	}
}
