/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.font;


import com.adobe.xfa.gfx.GFXColour;
import com.adobe.xfa.gfx.GFXGlyphOrientation;
import com.adobe.xfa.gfx.GFXTextAttr;

import com.adobe.xfa.ut.UnitSpan;


/**
 * This immutable class describes a
 * structure populated by resolveXFAFont for use with in gfx environment
 *
 * @exclude from published api.
 */
public class GfxTextAttrs {
	
	public GfxTextAttrs() {
		this(
			new GFXColour(255,255,255,255),
			GFXTextAttr.UNDER_NONE,
			GFXTextAttr.OVER_NONE,
			GFXTextAttr.STRIKEOUT_NONE,
			UnitSpan.ZERO,
			GFXGlyphOrientation.HORIZONTAL);
	}

	public GfxTextAttrs(
			GFXColour colour,
			int eUndercode,
			int eOvercode,
			int eStrikeOut,
			UnitSpan baselineShift,
			int eGlyphOrientation) {
		
		m_oColour = colour;
		m_eUndercode = eUndercode;
		m_eOvercode = eOvercode;
		m_eStrikeOut = eStrikeOut;
		m_oBaseLineShift = baselineShift;
		m_eGlyphOrientation = eGlyphOrientation;
	}

	public final GFXColour m_oColour;
	public final int m_eUndercode;
	public final int m_eOvercode;
	public final int m_eStrikeOut;
	public final UnitSpan m_oBaseLineShift;
	public final int m_eGlyphOrientation;
	//public final String m_sOriginalTypeface;

}
