/*************************************************************************
 *
 *	File: DataMatrixByteCompactor.java
 *
 **************************************************************************
 * 
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.xfa.pmp.datamatrixpmp;

/**
 * Ported from DataMatrixByteCompactor.cpp
 */
class DataMatrixByteCompactor extends DataMatrixBaseCompactor {
	private static final int BASE256LATCH = 231;

	// ////////////////////////////////////////////////////////////////////
	/**
	 * Do the byte compaction.
	 * 
	 * @param message
	 *            - The input binary message.
	 * @returns A vector of the of the binary encoded message in PDF417 code
	 *          words.
	 */
	// ////////////////////////////////////////////////////////////////////
	void compact(char[] message) {
		m_codeWords.clear();
		m_valid = false;

		int position = 2;

		int messageSize = message.length;
		if (messageSize < 1)
			return;

		// Append length field
		m_codeWords.add(BASE256LATCH);

		if (messageSize <= 249) {
			m_codeWords.add(State255Randomize(messageSize, position++));
		} else if (messageSize <= 1555) {
			int d1 = (messageSize / 250) + 249;
			int d2 = messageSize % 250;
			m_codeWords.add(State255Randomize(d1, position++));
			m_codeWords.add(State255Randomize(d2, position++));
		} else
			return;

		for (int idx = 0; idx < messageSize; idx++)
			m_codeWords.add(State255Randomize(message[idx], position++));

		// Find the symbol size that will fit the data.
		m_symbolSize = findSymbolSize(m_codeWords.size());
		if (m_symbolSize == -1)
			return; // Can't fit the data

		// Pad the data. No need to unlatch since we are in ASCII mode already.
		DataMatrixPadder.addPadding(m_codeWords, m_symbolSize);

		m_valid = true;
	}

	static int State255Randomize(int codeWord, int position) {
		int random = ((149 * position) % 255) + 1;
		int temp = codeWord + random;
		if (temp <= 255)
			return (temp);
		return (temp - 256);
	}
}
