/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security;

import java.util.Iterator;

/**
 * A Group is a Set of Authorizables. They are a method to specify a single
 * authorization to multiple Authorizables at once.
 *
 * @see Authorizable
 * @deprecated cq 5.5 Use org.apache.jackrabbit.api.security.user.Group instead.
 */
public interface Group extends Authorizable {

    /**
     * Checks if the given Authorizable is a member of the current Group.
     * This check will validate to true for transitive group membership.
     * Example:
     * if Authorizable A is a direct member of Group G2 and G2 is a direct
     * member of Group G1, than G1.isMember(A) == true.
     * But G1.remove(A) == false as A only can be removed from G2
     *
     * @param authorizable in question
     * @return <code>true</code> if the given authorizable is member of this group.
     */
    boolean isMember(Authorizable authorizable);

    /**
     * Return all Authorizables that are direct members of this Group.
     * No transitive membership is contained, thus a call to each returned
     * Authorizables {@link com.day.cq.security.Authorizable#memberOf() memberOf-method}
     * contains this Group.
     *
     * @return Iterator containing all direct Members of this Group
     */
    Iterator<Authorizable> members();

    /**
     * The implementation is no required to check for circular membership definition.
     *
     * @param authorizable to add as a Member
     * @return true if the Authorizable has not been contained beforehand
     */
    boolean addMember(Authorizable authorizable);

    /**
     * <p>removeMember.</p>
     *
     * @param authorizable to remove
     * @return true if the Authorizable has been member before
     */
    boolean removeMember(Authorizable authorizable);

}
