/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.privileges;

import com.day.cq.security.Authorizable;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import java.util.Collection;

/**
 * Storage for {@link Privilege Privileges'}
 * optional configuration data.<br>
 * Releaves {@link PrivilegeFactory
 * PrivilegeFactories} from the management and possible errors on protection etc.
 *
 * The Store provieds a {@link javax.jcr.Node Node} for each
 * Privilege-Authorizable combination. Which can be further used as persistence.
 * The Store must enforce proper access-rights.
 *
 * @deprecated CQ 5.5
 */
public interface PrivilegeStore {

    /**
     * <p>hasPrivilege.</p>
     *
     * @param authorizable a {@link com.day.cq.security.Authorizable} object.
     * @param privilegePath a {@link java.lang.String} object.
     * @return a boolean.
     * @throws javax.jcr.AccessDeniedException if any.
     */
    boolean hasPrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    /**
     * <p>getPrivilegeNode.</p>
     *
     * @param authorizable a {@link com.day.cq.security.Authorizable} object.
     * @param privilegePath a {@link java.lang.String} object.
     * @return a {@link javax.jcr.Node} object.
     * @throws javax.jcr.AccessDeniedException if any.
     */
    Node getPrivilegeNode(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    /**
     * <p>getPrivileges.</p>
     *
     * @param authorizable a {@link com.day.cq.security.Authorizable} object.
     * @return a {@link java.util.Collection} object.
     * @throws javax.jcr.AccessDeniedException if any.
     */
    Collection<String> getPrivileges(Authorizable authorizable)
            throws AccessDeniedException;

    /**
     * <p>setPrivilege.</p>
     *
     * @param authorizable a {@link com.day.cq.security.Authorizable} object.
     * @param privilegePath a {@link java.lang.String} object.
     * @throws javax.jcr.AccessDeniedException if any.
     */
    void setPrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;

    /**
     * <p>removePrivilege.</p>
     *
     * @param authorizable a {@link com.day.cq.security.Authorizable} object.
     * @param privilegePath a {@link java.lang.String} object.
     * @throws javax.jcr.AccessDeniedException if any.
     */
    void removePrivilege(Authorizable authorizable, String privilegePath)
            throws AccessDeniedException;
}
