/*
 * Copyright 1997-2009 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.security.profile;

import com.day.cq.commons.LabeledResource;
import com.day.cq.security.Authorizable;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.Resource;

import java.util.Iterator;

/**
 * The Profile is an Extension of the {@link Authorizable User} Properties.
 * While the Authorizable is a Unique entity it may have multiple Profiles.
 * A Profile may be specific for an Application of the CQ-Platform.
 * It is therefore modelled via this Object and not maintained directly on the
 * Authorizable.
 * The relation to an {@link com.day.cq.security.Authorizable Authorizable} and
 * the persistance handling is done by the
 * {@link com.day.cq.security.profile.ProfileManager ProfileManager}
 *
 * @see Authorizable
 * @see ProfileManager
 * @deprecated cq 5.5
 */
public interface Profile extends LabeledResource, PersistableValueMap {

    /**
     * <p>getAuthorizable.</p>
     *
     * @return this Profile belongs to
     */
    Authorizable getAuthorizable();

    /**
     * <p>getPath.</p>
     *
     * @return Path of the Resource containing the profile data
     */
    String getPath();

    /**
     * <p>getFamilyName.</p>
     *
     * @return Family or Last Name or <code>null</code> if none
     */
    String getFamilyName();

    /**
     * <p>getGivenName.</p>
     *
     * @return Given or First Name <code>null</code> if none
     */
    String getGivenName();

    /**
     * <p>getMiddleName.</p>
     *
     * @return Given or First Name <code>null</code> if none
     */
    String getMiddleName();

    /**
     * <p>getHonoricPrefix.</p>
     *
     * @return Honric Prefix like Ph.D <code>null</code> if none
     */
    String getHonoricPrefix();

    /**
     * <p>getHonoricSuffix.</p>
     *
     * @return Honric Suffix or <code>null</code> if none
     */
    String getHonoricSuffix();

    /**
     * <p>getFormattedName.</p>
     *
     * @return formatted name of the profile
     */
    String getFormattedName();

    /**
     * <p>getPrimaryMail.</p>
     *
     * @return e-mail address marked to be primary or <code>null</code> if none
     */
    String getPrimaryMail();

    /**
     * A Profile may contain mulitple E-Mail addresses.
     * These multiple addresses are stored in dedicated resources, containing
     * the e-mail address and descriptive data.
     * It is not mandated, that the {@link #getPrimaryMail() primary E-Mail}
     * is contained in one of the {@link Resource Resources} contained in this result
     *
     * @return all Resources containing detailed properties about mail addresses.
     * @see #getPrimaryMail()
     */
    Iterator<Resource> getMails();

    /**
     * <p>getPrimaryPhone.</p>
     *
     * @return address marked to be primary or <code>null</code> if none
     */
    String getPrimaryPhone();

    /**
     * A Profile may contain mulitple Phone numbers addresses.
     * These multiple phone numbers are stored in dedicated resources, containing
     * the number and descriptive data.
     * It is not mandated, that the {@link #getPrimaryPhone() primary phone number}
     * is contained in one of the {@link Resource Resources} contained in this result
     *
     * @return all Resources containing detailed properties about phone numbers.
     * @see #getPrimaryPhone()
     */
    Iterator<Resource> getPhoneNumbers();

    /**
     * <p>getCurrentLocation.</p>
     *
     * @return a {@link org.apache.sling.api.resource.Resource} object.
     */
    Resource getCurrentLocation();

    /**
     * <p>getAddresses.</p>
     *
     * @return a {@link java.util.Iterator} object.
     */
    Iterator<Resource> getAddresses();

    /**
     * <p>getURLs.</p>
     *
     * @return a {@link java.util.Iterator} object.
     */
    Iterator<Resource> getURLs();

    /**
     * <p>getPhotos.</p>
     *
     * @return a {@link java.util.Iterator} object.
     */
    Iterator<Resource> getPhotos();

    /**
     * <p>getOrganizations.</p>
     *
     * @return a {@link java.util.Iterator} object.
     */
    Iterator<Resource> getOrganizations();

    /**
     * <p>getAccounts.</p>
     *
     * @return a {@link java.util.Iterator} object.
     */
    Iterator<Resource> getAccounts();

    /**
     * Returns the avatar URL of the profile.
     *
     * @param suffix Suffix to append to the avatar URL
     * @param defaultValue Default value if Profile has no avatar
     * @return avatar URL or the default value
     */
    String getAvatarURL(String suffix, String defaultValue);
}
