/*
 * Copyright 1997-2008 Day Management AG
 * Barfuesserplatz 6, 4001 Basel, Switzerland
 * All Rights Reserved.
 *
 * This software is the confidential and proprietary information of
 * Day Management AG, ("Confidential Information"). You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Day.
 */
package com.day.cq.wcm.msm.api;

import java.util.Map;

import com.day.cq.commons.JSONItem;

/**
 * An <code>ActionConfig</code> is the config of a {@link LiveAction} during a
 * perform a rollout. It is composed of a name and a set of properties that can be used by the action.
 * @see LiveAction
 * @deprecated since 5.5
 */
@Deprecated
public interface ActionConfig extends Comparable<ActionConfig>, JSONItem {
    /**
     * Returns the name of the action.
     * @return the name
     */
    public String getName();

    /**
     * Returns the request parameter name of the action.
     * @return the parameter name
     */
    public String getParameterName();

    /**
     * Returns the map of properties
     * @return the map or an empty map
     */
    public Map<String,String> getProperties();

    /**
     * Returns the value of one property
     * @param propertyName Name of the property to retrieve
     * @return the value or null.
     */
    public String getProperty(String propertyName);

    /**
     * Returns if the action contains the defined property.
     * @param propertyName The name of the property to test
     * @return True if action contains the defined property, false otherwise.
     */
    public boolean hasProperty(String propertyName);

    /**
     * Returns the rank of the action (allows to classify several actions).
     * @return the rank
     */
    public int getRank();
}
