/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.wcm.core.components.commons.editor.dialog.childreneditor;

import com.day.cq.i18n.I18n;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.msm.api.LiveRelationshipManager;
import com.day.text.Text;
import java.util.Optional;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item {
    public static final Logger LOG = LoggerFactory.getLogger(Item.class);
    protected String name;
    protected String value;
    protected String title;
    protected String iconName;
    protected String iconPath;
    protected String iconAbbreviation;
    protected boolean isLiveCopy;
    String PN_PANEL_TITLE = "cq:panelTitle";
    String PN_ICON = "cq:icon";
    String PN_ABBREVIATION = "abbreviation";
    String PN_ABBREVIATION_I18N = "abbreviation_commentI18n";
    String NN_ICON_PNG = "cq:icon.png";
    String NN_ICON_SVG = "cq:icon.svg";

    public Item(SlingHttpServletRequest request, Resource resource) {
        ComponentManager componentManager;
        String translationContext = null;
        String titleI18n = null;
        I18n i18n = new I18n(request);
        if (resource != null) {
            this.name = resource.getName();
            ValueMap vm = resource.getValueMap();
            this.value = Optional.ofNullable((String)((Object)vm.get(this.PN_PANEL_TITLE, String.class))).orElseGet(() -> (String)((Object)vm.get("jcr:title", String.class)));
            LiveRelationshipManager mgr = request.getResourceResolver().adaptTo(LiveRelationshipManager.class);
            if (mgr != null) {
                try {
                    this.isLiveCopy = mgr.hasLiveRelationship(resource) && !mgr.getLiveRelationship(resource, true).getStatus().isCancelled();
                }
                catch (WCMException e) {
                    LOG.error("Something went wrong while checking live copy status for resource {}", (Object)resource.getPath(), (Object)e);
                }
            }
        }
        if ((componentManager = request.getResourceResolver().adaptTo(ComponentManager.class)) != null) {
            Component component = componentManager.getComponentOfResource(resource);
            if (component != null) {
                this.title = component.getTitle();
                titleI18n = i18n.getVar(this.title);
                if (this.title == null) {
                    this.title = Text.getName(component.getPath());
                }
            }
            while (component != null) {
                Resource res = component.adaptTo(Resource.class);
                if (res != null) {
                    ValueMap valueMap = res.getValueMap();
                    this.iconName = (String)((Object)valueMap.get(this.PN_ICON, String.class));
                    if (this.iconName != null) break;
                    this.iconAbbreviation = (String)((Object)valueMap.get(this.PN_ABBREVIATION, String.class));
                    if (this.iconAbbreviation != null) {
                        translationContext = (String)((Object)valueMap.get(this.PN_ABBREVIATION_I18N, String.class));
                        break;
                    }
                    Resource png = res.getChild(this.NN_ICON_PNG);
                    if (png != null) {
                        this.iconPath = png.getPath();
                        break;
                    }
                    Resource svg = res.getChild(this.NN_ICON_SVG);
                    if (svg != null) {
                        this.iconPath = svg.getPath();
                        break;
                    }
                }
                component = component.getSuperComponent();
            }
        }
        if (this.iconAbbreviation != null && !"".equals(this.iconAbbreviation) && translationContext != null) {
            this.iconAbbreviation = i18n.getVar(this.iconAbbreviation, translationContext);
        } else if (this.iconName == null && this.iconAbbreviation == null && this.iconPath == null || "".equals(this.iconAbbreviation)) {
            String string = this.iconAbbreviation = titleI18n == null ? this.title : titleI18n;
            if (this.iconAbbreviation.length() >= 2) {
                this.iconAbbreviation = this.iconAbbreviation.substring(0, 2);
            } else if (this.iconAbbreviation.length() == 1) {
                this.iconAbbreviation = String.valueOf(this.iconAbbreviation.charAt(0));
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getTitle() {
        return this.title;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getIconAbbreviation() {
        return this.iconAbbreviation;
    }

    public boolean isLiveCopy() {
        return this.isLiveCopy;
    }
}

