/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.mac.resource;

final class ScriptUtility {
    private static final String[][] SCRIPTID_TO_ENCODING = new String[][]{{"MacRoman"}, {"macjapanese"}, {"MacChineseTraditional"}, {"MacKorean"}, {"MacArabic"}, {"MacHebrew"}, {"MacGreek"}, {"MacCyrillic"}, {"MacSymbol"}, {"MacDevanagari"}, {"MacGurmukhi"}, {"MacGujarati"}, new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], new String[0], {"MacThai"}, new String[0], new String[0], new String[0], {"MacChineseSimplified"}, new String[0], new String[0], new String[0], {"MacCentralEuropean"}, new String[0], new String[0], new String[0]};

    private ScriptUtility() {
    }

    static final int scriptCodeFromRsrcID(int rsrcID) {
        int script = (rsrcID - 15872) / 512;
        if (script < 0) {
            script = 0;
        }
        return script;
    }

    static final String scriptCodeToCharset(int script) {
        String[] encodingArray = SCRIPTID_TO_ENCODING[script = Math.min(script, SCRIPTID_TO_ENCODING.length - 1)];
        if (encodingArray.length == 0) {
            return SCRIPTID_TO_ENCODING[0][0];
        }
        return encodingArray[0];
    }
}

