/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.AbstractPredicateEvaluator;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.XPath;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.extractors.DistinctValuesFacetExtractor;
import com.day.cq.search.impl.util.GlobPatternUtil;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.apache.jackrabbit.util.Text;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceVendor(value="Adobe Systems Incorporated")
@Component(factory="com.day.cq.search.eval.PredicateEvaluator/property")
public class JcrPropertyPredicateEvaluator
extends AbstractPredicateEvaluator {
    private static final Logger log = LoggerFactory.getLogger(JcrPropertyPredicateEvaluator.class);
    public static final String PROPERTY = "property";
    public static final String VALUE = "value";
    public static final String OPERATION = "operation";
    public static final String OP_EQUALS = "equals";
    public static final String OP_UNEQUALS = "unequals";
    public static final String OP_LIKE = "like";
    public static final String OP_NOT = "not";
    public static final String OP_EXISTS = "exists";
    public static final String OP_EQUALS_IGNORE_CASE = "equalsIgnoreCase";
    public static final String OP_UNEQUALS_IGNORE_CASE = "unequalsIgnoreCase";
    public static final String AND = "and";
    public static final String DEPTH = "depth";
    public static final String STEP = "*/";
    public static final int MAX_NUMBER_OF_VALUES = Integer.MAX_VALUE;

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        String property = p.get(PROPERTY);
        int depth = Integer.parseInt(p.get(DEPTH, "0"));
        String operation = p.get(OPERATION);
        if (OP_NOT.equals(operation) || OP_EXISTS.equals(operation) || p.hasNonEmptyValue(VALUE)) {
            return this.getXPathExpression(property, p.get(VALUE), this.getOperation(p, operation), depth);
        }
        boolean and = p.getBool(AND);
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (Map.Entry<String, String> entry : p.getParameters().entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.endsWith("_value")) continue;
            if (builder.length() > 1) {
                builder.append(and ? " and " : " or ");
            }
            builder.append(this.getXPathExpression(property, entry.getValue(), operation, depth));
        }
        if (builder.length() == 1) {
            return null;
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getXPathExpression(String property, String value, String operation, int depth) {
        String expr = this.getXPathExpression(property, value, operation);
        StringBuilder builder = new StringBuilder();
        if (depth > 0) {
            builder.append("(");
        }
        if (null != operation && operation.equals(OP_LIKE)) {
            StringBuilder wildCardBuilder = new StringBuilder();
            String exprWithWildCard = "";
            for (int i = 0; i <= depth; ++i) {
                if (i > 0) {
                    builder.append(" or ");
                    wildCardBuilder.setLength(0);
                    for (int j = 0; j < i; ++j) {
                        wildCardBuilder.append(STEP);
                    }
                    exprWithWildCard = expr.replace(XPath.getPropertyPath(property), wildCardBuilder.toString() + XPath.getPropertyPath(property));
                    builder.append(exprWithWildCard);
                    continue;
                }
                builder.append(expr);
            }
        } else {
            for (int i = 0; i <= depth; ++i) {
                if (i > 0) {
                    builder.append(" or ");
                    for (int j = 0; j < i; ++j) {
                        builder.append(STEP);
                    }
                }
                builder.append(expr);
            }
        }
        if (depth > 0) {
            builder.append(")");
        }
        return builder.toString();
    }

    protected String getXPathExpression(String property, String value, String operation) {
        if (property == null || property.length() == 0 || !OP_NOT.equals(operation) && !OP_EXISTS.equals(operation) && (value == null || value.length() == 0)) {
            return null;
        }
        if (OP_EQUALS.equals(operation)) {
            return XPath.getEqualsExpression(property, value);
        }
        if (OP_UNEQUALS.equals(operation)) {
            return XPath.getUnequalsExpression(property, value);
        }
        if (OP_LIKE.equals(operation)) {
            return XPath.getJcrLikeExpression(property, value);
        }
        if (OP_EQUALS_IGNORE_CASE.equals(operation)) {
            return XPath.getCaseInsensitiveEqualsExpression(property, value);
        }
        if (OP_UNEQUALS_IGNORE_CASE.equals(operation)) {
            return XPath.getCaseInsensitiveUnqualsExpression(property, value);
        }
        if (OP_EXISTS.equals(operation)) {
            return XPath.getPropertyPath(property);
        }
        if (OP_NOT.equals(operation)) {
            return XPath.getNotExpression(property);
        }
        return XPath.getEqualsExpression(property, value);
    }

    protected String getEqualsExpression(String property, String value) {
        return XPath.getEqualsExpression(property, value);
    }

    private String getOperation(Predicate p, String operation) {
        if (OP_EXISTS.equals(operation) && "false".equals(p.get(VALUE, "true"))) {
            operation = OP_NOT;
        }
        return operation;
    }

    @Override
    public String[] getOrderByProperties(Predicate p, EvaluationContext context) {
        return new String[]{p.get(PROPERTY)};
    }

    @Override
    public FacetExtractor getFacetExtractor(Predicate p, EvaluationContext context) {
        if (p.hasNonEmptyValue(PROPERTY)) {
            Predicate template = p.clone();
            template.set(OPERATION, OP_EQUALS);
            return new DistinctValuesFacetExtractor(p.get(PROPERTY), null, template, VALUE);
        }
        return null;
    }

    @Override
    public boolean includes(Predicate p, Row row, EvaluationContext context) {
        String operation = p.get(OPERATION, OP_EQUALS);
        int depth = Integer.parseInt(p.get(DEPTH, "0"));
        if (OP_NOT.equals(operation) || OP_EXISTS.equals(operation) || p.hasNonEmptyValue(VALUE)) {
            return this.includes(context.getNode(row), context.getPath(row), p.get(PROPERTY), p.get(VALUE), this.getOperation(p, operation), depth);
        }
        boolean and = p.getBool(AND);
        operation = this.getOperation(p, operation);
        boolean emptyPredicate = true;
        for (Map.Entry<String, String> entry : p.getParameters().entrySet()) {
            String key = entry.getKey();
            if (key == null || !key.endsWith("_value")) continue;
            emptyPredicate = false;
            boolean match = this.includes(context.getNode(row), context.getPath(row), p.get(PROPERTY), entry.getValue(), operation, depth);
            if (and) {
                if (match) continue;
                return false;
            }
            if (!match) continue;
            return true;
        }
        if (and) {
            return true;
        }
        return emptyPredicate;
    }

    protected boolean includes(Node node, String path, String property, String value, String operation, int depth) {
        boolean matches = this.includes(node, path, property, value, operation);
        if (!matches && depth > 0) {
            try {
                NodeIterator it = node.getNodes();
                while (!matches && it.hasNext()) {
                    matches = this.includes((Node)it.next(), path, property, value, operation, depth - 1);
                }
            }
            catch (RepositoryException e) {
                log.error("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", e);
                throw new RuntimeException("", e);
            }
        }
        return matches;
    }

    protected boolean includes(Node node, String path, String property, String value, String operation) {
        if (property == null || property.length() == 0 || !OP_NOT.equals(operation) && !OP_EXISTS.equals(operation) && (value == null || value.length() == 0)) {
            return true;
        }
        try {
            String childNode = Text.getRelativeParent(property, 1);
            String propName = Text.getName(property);
            if (childNode.length() > 0) {
                if (node.hasNode(childNode)) {
                    node = node.getNode(childNode);
                } else {
                    return false;
                }
            }
            if (node.hasProperty(propName)) {
                Property prop = node.getProperty(propName);
                if (prop.isMultiple()) {
                    if (OP_NOT.equals(operation)) {
                        return prop.getValues() == null || prop.getValues().length == 0;
                    }
                    if (OP_EXISTS.equals(operation)) {
                        return prop.getValues() != null && prop.getValues().length > 0;
                    }
                    for (Value v : prop.getValues()) {
                        if (!this.matches(value, operation, v.getString())) continue;
                        return true;
                    }
                    return false;
                }
                return this.matches(value, operation, prop.getString());
            }
            if (OP_NOT.equals(operation)) {
                return true;
            }
            if (OP_EXISTS.equals(operation)) {
                return false;
            }
            return false;
        }
        catch (ValueFormatException e) {
            log.warn("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", e);
        }
        catch (RepositoryException e) {
            log.error("Could not evaluate property = '" + property + "', value = '" + value + "', node = '" + path + "'", e);
            throw new RuntimeException("", e);
        }
        return true;
    }

    private boolean matches(String value, String operation, String propValue) {
        if (OP_NOT.equals(operation)) {
            return propValue == null;
        }
        if (OP_EXISTS.equals(operation)) {
            return propValue != null;
        }
        if (OP_EQUALS.equals(operation)) {
            return propValue.equals(value);
        }
        if (OP_UNEQUALS.equals(operation)) {
            return !propValue.equals(value);
        }
        if (OP_LIKE.equals(operation)) {
            return Pattern.matches(this.convertWildcardsForGlobPattern(value), propValue);
        }
        if (OP_EQUALS_IGNORE_CASE.equals(operation)) {
            return propValue.equalsIgnoreCase(value);
        }
        if (OP_UNEQUALS_IGNORE_CASE.equals(operation)) {
            return !propValue.equalsIgnoreCase(value);
        }
        return false;
    }

    private String convertWildcardsForGlobPattern(String term) {
        term = term.replace('%', '*').replace('_', '?');
        return GlobPatternUtil.convertWildcardToRegex((String)term);
    }

    @Override
    public boolean canXpath(Predicate predicate, EvaluationContext context) {
        return true;
    }

    @Override
    public boolean canFilter(Predicate predicate, EvaluationContext context) {
        return true;
    }
}

