/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.commons.DiffInfo;
import com.day.cq.wcm.foundation.Paragraph;
import com.day.text.Text;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParagraphSystem {
    public static final Logger log = LoggerFactory.getLogger(ParagraphSystem.class);
    public static final String PARAMETER_VERSION_DIFF = "cq_diffTo";
    public static final String PARAMETER_VERSION_VIEW = "cq_view";
    public static final String COL_CTL_TYPE = "controlType";
    public static final String COL_CTL_LAYOUT = "layout";
    private final Resource resource;
    private final ResourceResolver resolver;
    private String colCtrlResourceType;
    private String colCtrlSuffix = "/colctrl";
    private String defaultLayout = "1;cq-colctrl-default";
    private List<Paragraph> paras;
    private final String versionLabel;
    private final boolean isVersionDiff;

    public static ParagraphSystem create(Resource resource, SlingHttpServletRequest req) {
        boolean isDiff;
        RequestParameter parameter = req.getRequestParameter(PARAMETER_VERSION_DIFF);
        String label = null;
        if (null != parameter) {
            try {
                label = parameter.getString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.warn("create: error while decoding diff view parameter: ", e);
            }
        }
        boolean bl = isDiff = label != null;
        if (label == null) {
            label = req.getParameter(PARAMETER_VERSION_VIEW);
        }
        return new ParagraphSystem(resource, label, isDiff);
    }

    public ParagraphSystem(Resource resource) {
        this(resource, null, true);
    }

    public ParagraphSystem(Resource resource, String versionLabel) {
        this(resource, versionLabel, true);
    }

    public ParagraphSystem(Resource resource, String versionLabel, boolean isVersionDiff) {
        this.isVersionDiff = isVersionDiff;
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        String type = resource.getResourceType() + this.colCtrlSuffix;
        if (type.startsWith("/")) {
            for (String sp : this.resolver.getSearchPath()) {
                if (!type.startsWith(sp)) continue;
                type = type.substring(sp.length());
                break;
            }
        }
        this.versionLabel = versionLabel != null && versionLabel.trim().length() > 0 ? versionLabel : null;
    }

    public void setColCtrlResourceType(String colCtrlResourceType) {
        this.colCtrlResourceType = colCtrlResourceType;
    }

    public String getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(String defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public List<Paragraph> paragraphs() {
        this.initParas(false);
        return this.paras;
    }

    public void repair() {
        this.paras = null;
        this.initParas(true);
    }

    private void initParas(boolean fixContentStructure) {
        if (this.paras != null) {
            return;
        }
        Resource versionResource = null;
        if (this.resource.adaptTo(Node.class) == null) {
            if (fixContentStructure) {
                try {
                    String path = this.resource.getPath();
                    int idx = path.lastIndexOf(47);
                    String parentPath = path.substring(0, idx);
                    String name = path.substring(idx + 1);
                    Session s = this.resolver.adaptTo(Session.class);
                    Node parentNode = (Node)s.getItem(parentPath);
                    Node parNode = parentNode.addNode(name);
                    parNode.setProperty("sling:resourceType", this.resource.getResourceType());
                }
                catch (Exception e) {
                    log.warn("Could not create missing {} node.", (Object)this.resource.getPath(), (Object)e);
                }
            }
        } else if (this.versionLabel != null) {
            versionResource = DiffInfo.getVersionedResource(this.resource, this.versionLabel);
        }
        if (versionResource != null && !this.isVersionDiff) {
            this.paras = this.collectParagraphs(versionResource, false);
        } else {
            this.paras = this.collectParagraphs(this.resource, fixContentStructure);
            if (versionResource != null) {
                List<Paragraph> versionedParas = this.collectParagraphs(versionResource, false);
                this.compare(this.paras, versionedParas);
            }
        }
    }

    private List<Paragraph> collectParagraphs(Resource resource, boolean fixStructure) {
        LinkedList<Paragraph> paragraphs = new LinkedList<Paragraph>();
        int colNum = 0;
        int numCols = 0;
        String layout = "default";
        LinkedList<Paragraph> toRemove = new LinkedList<Paragraph>();
        LinkedList<Paragraph> toCreate = new LinkedList<Paragraph>();
        Resource lastStartResource = null;
        int lastStartIndex = 0;
        Resource followingLastStartResource = null;
        Iterator<Resource> iter = this.resolver.listChildren(resource);
        while (iter.hasNext()) {
            Resource res = iter.next();
            if (lastStartResource != null && followingLastStartResource == null) {
                followingLastStartResource = res;
            }
            if (res.getResourceType().endsWith(this.colCtrlSuffix)) {
                ValueMap resProps = res.adaptTo(ValueMap.class);
                Paragraph.Type type = null;
                try {
                    type = Paragraph.Type.valueOf(resProps.get(COL_CTL_TYPE, "start").toUpperCase());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (type == Paragraph.Type.START) {
                    this.colCtrlResourceType = res.getResourceType();
                    if (numCols > 0 && fixStructure) {
                        Paragraph para;
                        while (colNum < numCols - 1) {
                            para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            if (followingLastStartResource != null) {
                                paragraphs.add(++lastStartIndex, para);
                            } else {
                                paragraphs.add(para);
                            }
                            toCreate.add(para);
                        }
                        para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
                        if (followingLastStartResource != null) {
                            paragraphs.add(++lastStartIndex, para);
                        } else {
                            paragraphs.add(para);
                        }
                        toCreate.add(para);
                    }
                    colNum = 0;
                    numCols = 1;
                    layout = resProps.get(COL_CTL_LAYOUT, this.defaultLayout);
                    int i = layout.indexOf(59);
                    if (i > 0) {
                        try {
                            numCols = Integer.parseInt(layout.substring(0, i));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        layout = layout.substring(i + 1);
                    }
                    Paragraph toInsert = new Paragraph(res, type, colNum, layout, numCols);
                    paragraphs.add(toInsert);
                    lastStartResource = res;
                    lastStartIndex = paragraphs.indexOf(toInsert);
                    followingLastStartResource = null;
                    continue;
                }
                if (type == Paragraph.Type.BREAK) {
                    Paragraph para = new Paragraph(res, type, ++colNum, layout, numCols);
                    if (numCols > 0) {
                        if (colNum >= numCols) {
                            toRemove.add(para);
                            continue;
                        }
                        paragraphs.add(para);
                        continue;
                    }
                    toRemove.add(para);
                    continue;
                }
                if (type == Paragraph.Type.END) {
                    if (numCols > 0) {
                        while (colNum < numCols - 1 && fixStructure) {
                            Paragraph para = new Paragraph(res, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            paragraphs.add(para);
                            toCreate.add(para);
                        }
                        numCols = 0;
                        colNum = 0;
                        paragraphs.add(new Paragraph(res, Paragraph.Type.END, colNum, layout, numCols));
                        continue;
                    }
                    Paragraph para = new Paragraph(res, Paragraph.Type.END);
                    toRemove.add(para);
                    continue;
                }
                Paragraph para = new Paragraph(res, Paragraph.Type.END);
                toRemove.add(para);
                continue;
            }
            paragraphs.add(new Paragraph(res, Paragraph.Type.NORMAL, colNum, layout, numCols));
        }
        if (numCols > 0 && fixStructure) {
            Paragraph para;
            while (colNum < numCols - 1) {
                para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                if (followingLastStartResource != null) {
                    paragraphs.add(++lastStartIndex, para);
                } else {
                    paragraphs.add(para);
                }
                toCreate.add(para);
            }
            para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
            if (followingLastStartResource != null) {
                paragraphs.add(++lastStartIndex, para);
            } else {
                paragraphs.add(para);
            }
            toCreate.add(para);
        }
        if (fixStructure) {
            try {
                this.fixStructure(toRemove, toCreate);
            }
            catch (RepositoryException e) {
                log.error("Error while fixing paragraph system structure.", e);
            }
        }
        return paragraphs;
    }

    private boolean fixStructure(List<Paragraph> toRemove, List<Paragraph> toCreate) throws RepositoryException {
        Node parent = this.resource.adaptTo(Node.class);
        for (Paragraph p : toRemove) {
            Node pn = p.adaptTo(Node.class);
            if (pn == null) continue;
            pn.remove();
        }
        int nr = 0;
        for (Paragraph p : toCreate) {
            String type = p.getType().toString().toLowerCase();
            Node node = parent.addNode("col_" + type + System.currentTimeMillis() + nr++);
            node.setProperty("sling:resourceType", this.colCtrlResourceType);
            node.setProperty(COL_CTL_TYPE, type);
            if (p.getResource() == null) continue;
            String beforeName = Text.getName(p.getResource().getPath());
            parent.orderBefore(node.getName(), beforeName);
        }
        return !toCreate.isEmpty() || !toRemove.isEmpty();
    }

    private void removeColumnLayoutParagraphs(List<Paragraph> list) {
        Iterator<Paragraph> i = list.iterator();
        while (i.hasNext()) {
            Paragraph p = i.next();
            if (p.getType() == Paragraph.Type.NORMAL) continue;
            i.remove();
        }
    }

    private void compare(List<Paragraph> orig, List<Paragraph> versioned) {
        Paragraph inP;
        Paragraph value;
        Paragraph outP;
        int j;
        int i;
        ArrayList<Paragraph> current = new ArrayList<Paragraph>(orig);
        this.removeColumnLayoutParagraphs(current);
        this.removeColumnLayoutParagraphs(versioned);
        int M = current.size();
        int N = versioned.size();
        ArrayList<Paragraph> out = new ArrayList<Paragraph>();
        ArrayList<Paragraph> in = new ArrayList<Paragraph>();
        ArrayList<Paragraph> moved = new ArrayList<Paragraph>();
        int[][] opt = new int[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = ResourceUtil.getName((Resource)current.get(i)).equals(ResourceUtil.getName(versioned.get(j))) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (ResourceUtil.getName((Resource)current.get(i)).equals(ResourceUtil.getName(versioned.get(j)))) {
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                if ((outP = this.search(out, value = (Paragraph)current.get(i++))) == null) {
                    in.add(value);
                    continue;
                }
                moved.add(value);
                out.remove(outP);
                continue;
            }
            if ((inP = this.search(in, value = versioned.get(j++))) == null) {
                out.add(value);
                continue;
            }
            moved.add(inP);
            in.remove(inP);
        }
        while (i < M || j < N) {
            if (i == M) {
                if ((inP = this.search(in, value = versioned.get(j++))) == null) {
                    out.add(value);
                    continue;
                }
                moved.add(inP);
                in.remove(inP);
                continue;
            }
            if (j != N) continue;
            if ((outP = this.search(out, value = (Paragraph)current.get(i++))) == null) {
                in.add(value);
                continue;
            }
            moved.add(value);
            out.remove(outP);
        }
        for (Paragraph v : in) {
            v.setDiffInfo(new DiffInfo(null, DiffInfo.TYPE.ADDED));
        }
        for (Paragraph v : out) {
            int pos;
            v.setDiffInfo(new DiffInfo(v.getResource(), DiffInfo.TYPE.REMOVED));
            for (pos = versioned.indexOf(v) + 1; pos < versioned.size(); ++pos) {
                Paragraph nextPara = this.search(orig, versioned.get(pos));
                if (nextPara == null) continue;
                int index = orig.indexOf(nextPara);
                orig.add(index, v);
                break;
            }
            if (pos != versioned.size()) continue;
            orig.add(v);
        }
        for (Paragraph v : moved) {
            v.setDiffInfo(new DiffInfo(this.search(versioned, v), DiffInfo.TYPE.MOVED));
        }
        for (Paragraph v : current) {
            if (v.adaptTo(DiffInfo.class) != null) continue;
            v.setDiffInfo(new DiffInfo(this.search(versioned, v), DiffInfo.TYPE.SAME));
        }
    }

    private Paragraph search(List<Paragraph> paras, Paragraph rsrc) {
        String title = ResourceUtil.getName(rsrc);
        for (Paragraph p : paras) {
            if (!ResourceUtil.getName(p).equals(title)) continue;
            return p;
        }
        return null;
    }
}

