/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.guava.common.base.Strings;
import org.apache.jackrabbit.guava.common.collect.Lists;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.CacheStatsMBean;
import org.apache.jackrabbit.oak.api.jmx.ConsolidatedDataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.blob.AbstractSharedCachingDataStore;
import org.apache.jackrabbit.oak.plugins.blob.DataStoreCacheStatsMBean;
import org.apache.jackrabbit.oak.plugins.blob.datastore.DataStoreBlobStore;
import org.apache.jackrabbit.oak.plugins.blob.datastore.InMemoryDataRecord;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Deprecated(since="2024-09-23")
@Component(service={})
public class ConsolidatedDataStoreCacheStats
implements ConsolidatedDataStoreCacheStatsMBean {
    private final List<Registration> registrations = Lists.newArrayList();
    private final List<DataStoreCacheStatsMBean> cacheStats = Lists.newArrayList();
    @Reference
    public AbstractSharedCachingDataStore cachingDataStore;
    @Reference
    public NodeStore nodeStore;

    @Override
    public TabularData getCacheStats() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(CacheStatsData.class.getName(), "Consolidated DataStore Cache Stats", CacheStatsData.TYPE, new String[]{"name"});
            tds = new TabularDataSupport(tt);
            for (DataStoreCacheStatsMBean stats : this.cacheStats) {
                tds.put(new CacheStatsData(stats).toCompositeData());
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Activate
    private void activate(BundleContext context) {
        OsgiWhiteboard wb = new OsgiWhiteboard(context);
        List<DataStoreCacheStatsMBean> allStats = this.cachingDataStore.getStats();
        for (DataStoreCacheStatsMBean stat : allStats) {
            this.registrations.add(WhiteboardUtils.registerMBean(wb, CacheStatsMBean.class, stat, "CacheStats", stat.getName()));
            this.cacheStats.add(stat);
        }
        this.registrations.add(WhiteboardUtils.registerMBean(wb, ConsolidatedDataStoreCacheStatsMBean.class, this, "ConsolidatedDataStoreCacheStats", "Consolidated DataStore Cache statistics"));
    }

    @Deactivate
    private void deactivate() {
        for (Registration r : this.registrations) {
            r.unregister();
        }
        this.registrations.clear();
    }

    @Override
    public boolean isFileSynced(String nodePathName) {
        if (Strings.isNullOrEmpty((String)nodePathName)) {
            return false;
        }
        if (null == this.nodeStore) {
            return false;
        }
        NodeState leafNode = this.findLeafNode(nodePathName);
        if (!leafNode.exists()) {
            return false;
        }
        boolean nodeHasBinaryProperties = false;
        for (PropertyState propertyState : leafNode.getProperties()) {
            nodeHasBinaryProperties |= propertyState.getType() == Type.BINARY || propertyState.getType() == Type.BINARIES;
            try {
                if (propertyState.getType() == Type.BINARY) {
                    Blob blob = (Blob)propertyState.getValue(propertyState.getType());
                    if (null != blob && this.haveRecordForBlob(blob)) continue;
                    return false;
                }
                if (propertyState.getType() != Type.BINARIES) continue;
                List blobs = (List)propertyState.getValue(propertyState.getType());
                if (null == blobs) {
                    return false;
                }
                for (Blob blob : blobs) {
                    if (this.haveRecordForBlob(blob)) continue;
                    return false;
                }
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return nodeHasBinaryProperties;
    }

    private NodeState findLeafNode(String nodePathName) {
        Iterable<String> pathNodes = PathUtils.elements(PathUtils.getParentPath(nodePathName));
        String leafNodeName = PathUtils.getName(nodePathName);
        NodeState currentNode = this.nodeStore.getRoot();
        for (String pathNodeName : pathNodes) {
            if (pathNodeName.length() <= 0) continue;
            NodeState childNode = currentNode.getChildNode(pathNodeName);
            if (!childNode.exists()) break;
            currentNode = childNode;
        }
        return currentNode.getChildNode(leafNodeName);
    }

    private boolean haveRecordForBlob(Blob blob) {
        String fullBlobId = blob.getContentIdentity();
        if (!Strings.isNullOrEmpty((String)fullBlobId) && !InMemoryDataRecord.isInstance(fullBlobId)) {
            String blobId = DataStoreBlobStore.BlobId.of(fullBlobId).getBlobId();
            return this.cachingDataStore.exists(new DataIdentifier(blobId));
        }
        return false;
    }

    static String timeInWords(long nanos) {
        long millis = TimeUnit.NANOSECONDS.toMillis(nanos);
        return String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
    }

    @Deprecated(since="2024-09-23")
    private static class CacheStatsData {
        static final String[] FIELD_NAMES = new String[]{"name", "requestCount", "hitCount", "hitRate", "missCount", "missRate", "loadCount", "loadSuccessCount", "loadExceptionCount", "totalLoadTime", "averageLoadPenalty", "evictionCount", "elementCount", "totalWeight", "totalMemWeight", "maxWeight"};
        static final String[] FIELD_DESCRIPTIONS = FIELD_NAMES;
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.BIGDECIMAL, SimpleType.LONG, SimpleType.BIGDECIMAL, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = CacheStatsData.createCompositeType();
        private final DataStoreCacheStatsMBean stats;

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(CacheStatsData.class.getName(), "Composite data type for Cache statistics", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }

        public CacheStatsData(DataStoreCacheStatsMBean stats) {
            this.stats = stats;
        }

        CompositeDataSupport toCompositeData() {
            Object[] values = new Object[]{this.stats.getName(), this.stats.getRequestCount(), this.stats.getHitCount(), new BigDecimal(this.stats.getHitRate(), new MathContext(2)), this.stats.getMissCount(), new BigDecimal(this.stats.getMissRate(), new MathContext(2)), this.stats.getLoadCount(), this.stats.getLoadSuccessCount(), this.stats.getLoadExceptionCount(), ConsolidatedDataStoreCacheStats.timeInWords(this.stats.getTotalLoadTime()), TimeUnit.NANOSECONDS.toMillis((long)this.stats.getAverageLoadPenalty()) + "ms", this.stats.getEvictionCount(), this.stats.getElementCount(), IOUtils.humanReadableByteCount(this.stats.estimateCurrentWeight()), IOUtils.humanReadableByteCount(this.stats.estimateCurrentMemoryWeight()), IOUtils.humanReadableByteCount(this.stats.getMaxTotalWeight())};
            try {
                return new CompositeDataSupport(TYPE, FIELD_NAMES, values);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

