/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.guava.common.collect.Iterables;
import org.apache.jackrabbit.guava.common.collect.Maps;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.api.jmx.CheckpointMBean;
import org.apache.jackrabbit.oak.api.jmx.IndexStatsMBean;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.jmx.ManagementOperation;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexInfoService;
import org.apache.jackrabbit.oak.plugins.index.IndexPathService;
import org.apache.jackrabbit.oak.plugins.index.lucene.ActiveDeletedBlobCollectorMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.directory.ActiveDeletedBlobCollectorFactory;
import org.apache.jackrabbit.oak.spi.blob.GarbageCollectableBlobStore;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.EmptyHook;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.stats.Clock;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveDeletedBlobCollectorMBeanImpl
implements ActiveDeletedBlobCollectorMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ActiveDeletedBlobCollectorMBeanImpl.class);
    private static final String OP_NAME = "Active lucene index blobs collection";
    private final long MIN_BLOB_AGE_TO_ACTIVELY_DELETE = Long.getLong("oak.active.deletion.minAge", TimeUnit.HOURS.toSeconds(24L));
    private final boolean ACTIVE_DELETION_DISABLED = Boolean.getBoolean("oak.active.deletion.disabled");
    Clock clock = Clock.SIMPLE;
    @NotNull
    private final ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector;
    @NotNull
    private Whiteboard whiteboard;
    @NotNull
    private final GarbageCollectableBlobStore blobStore;
    @NotNull
    private final Executor executor;
    private final NodeStore store;
    private final IndexPathService indexPathService;
    private final AsyncIndexInfoService asyncIndexInfoService;
    private ManagementOperation<Void> gcOp = ManagementOperation.done("Active lucene index blobs collection", null);

    public ActiveDeletedBlobCollectorMBeanImpl(@NotNull ActiveDeletedBlobCollectorFactory.ActiveDeletedBlobCollector activeDeletedBlobCollector, @NotNull Whiteboard whiteboard, @NotNull NodeStore store, @NotNull IndexPathService indexPathService, @NotNull AsyncIndexInfoService asyncIndexInfoService, @NotNull GarbageCollectableBlobStore blobStore, @NotNull Executor executor) {
        this.activeDeletedBlobCollector = Objects.requireNonNull(activeDeletedBlobCollector);
        this.whiteboard = Objects.requireNonNull(whiteboard);
        this.store = store;
        this.indexPathService = indexPathService;
        this.asyncIndexInfoService = asyncIndexInfoService;
        this.blobStore = Objects.requireNonNull(blobStore);
        this.executor = Objects.requireNonNull(executor);
        LOG.info("Active blob collector initialized with minAge: {}", (Object)this.MIN_BLOB_AGE_TO_ACTIVELY_DELETE);
    }

    @Override
    public boolean isDisabled() {
        return this.ACTIVE_DELETION_DISABLED;
    }

    @Override
    @NotNull
    public CompositeData startActiveCollection() {
        if (this.isDisabled()) {
            return ManagementOperation.Status.none(this.gcOp, "Active deletion is disabled").toCompositeData();
        }
        if (this.gcOp.isDone()) {
            long safeTimestampForDeletedBlobs = this.getSafeTimestampForDeletedBlobs();
            if (safeTimestampForDeletedBlobs == -1L) {
                return ManagementOperation.Status.failed("Active lucene index blobs collection couldn't be run as a safe timestamp for purging lucene index blobs couldn't be evaluated").toCompositeData();
            }
            this.gcOp = ManagementOperation.newManagementOperation(OP_NAME, () -> {
                this.activeDeletedBlobCollector.purgeBlobsDeleted(safeTimestampForDeletedBlobs, this.blobStore);
                return null;
            });
            this.executor.execute(this.gcOp);
            return ManagementOperation.Status.initiated(this.gcOp, "Active lucene index blobs collection started").toCompositeData();
        }
        return ManagementOperation.Status.failed("Active lucene index blobs collection already running").toCompositeData();
    }

    @Override
    @NotNull
    public CompositeData cancelActiveCollection() {
        if (!this.gcOp.isDone()) {
            this.executor.execute(ManagementOperation.newManagementOperation(OP_NAME, () -> {
                this.gcOp.cancel(false);
                this.activeDeletedBlobCollector.cancelBlobCollection();
                return null;
            }));
            return ManagementOperation.Status.initiated(this.gcOp, "Active lucene index blobs collection cancelled").toCompositeData();
        }
        return ManagementOperation.Status.failed("Active lucene index blobs collection not running").toCompositeData();
    }

    @Override
    @NotNull
    public CompositeData getActiveCollectionStatus() {
        return this.gcOp.getStatus().toCompositeData();
    }

    @Override
    public boolean isActiveDeletionUnsafe() {
        return this.activeDeletedBlobCollector.isActiveDeletionUnsafe();
    }

    @Override
    public void flagActiveDeletionUnsafeForCurrentState() {
        this.activeDeletedBlobCollector.flagActiveDeletionUnsafe(true);
        if (!this.waitForRunningIndexCycles()) {
            LOG.warn("Some indexers were still found running. Resume and quit gracefully");
            this.activeDeletedBlobCollector.flagActiveDeletionUnsafe(false);
        }
        try {
            this.markCurrentIndexFilesUnsafeForActiveDeletion();
        }
        catch (CommitFailedException e) {
            LOG.warn("Could not set current index files unsafe for active deletion. Resume and quit gracefully", e);
            this.activeDeletedBlobCollector.flagActiveDeletionUnsafe(false);
        }
    }

    @Override
    public void flagActiveDeletionSafe() {
        this.activeDeletedBlobCollector.flagActiveDeletionUnsafe(false);
    }

    private boolean waitForRunningIndexCycles() {
        Map origIndexLaneToExecutinoCountMap = Maps.asMap(new HashSet(StreamSupport.stream(this.asyncIndexInfoService.getAsyncLanes().spliterator(), false).map(lane -> this.asyncIndexInfoService.getInfo((String)lane).getStatsMBean()).filter(bean -> {
            String beanStatus;
            try {
                if (bean == null) {
                    return false;
                }
                beanStatus = bean.getStatus();
            }
            catch (Exception e) {
                LOG.warn("Exception during getting status for {}. Ignoring this indexer lane", (Object)bean.getName(), (Object)e);
                return false;
            }
            return "running".equals(beanStatus);
        }).collect(Collectors.toList())), IndexStatsMBean::getTotalExecutionCount);
        if (!origIndexLaneToExecutinoCountMap.isEmpty()) {
            LOG.info("Found running index lanes ({}). Sleep a bit before continuing.", (Object)Iterables.transform(origIndexLaneToExecutinoCountMap.keySet(), IndexStatsMBean::getName));
            try {
                this.clock.waitUntil(this.clock.getTime() + TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                LOG.info("Thread interrupted during initial wait", e);
                Thread.currentThread().interrupt();
            }
        }
        long start = this.clock.getTime();
        while (!origIndexLaneToExecutinoCountMap.isEmpty()) {
            Map.Entry indexLaneEntry = origIndexLaneToExecutinoCountMap.entrySet().iterator().next();
            IndexStatsMBean indexLaneBean = (IndexStatsMBean)indexLaneEntry.getKey();
            long oldExecCnt = (Long)indexLaneEntry.getValue();
            long newExecCnt = indexLaneBean.getTotalExecutionCount();
            String beanStatus = indexLaneBean.getStatus();
            if (!"running".equals(beanStatus) || oldExecCnt != newExecCnt) {
                origIndexLaneToExecutinoCountMap.remove(indexLaneBean);
                LOG.info("Lane {} has moved - oldExecCnt {}, newExecCnt {}", indexLaneBean.getName(), oldExecCnt, newExecCnt);
                continue;
            }
            if (this.clock.getTime() - start > TimeUnit.MINUTES.toMillis(2L)) {
                LOG.warn("Timed out while waiting for running index lane executions");
                break;
            }
            LOG.info("Lane {} still has execution count {}. Waiting....", (Object)indexLaneBean.getName(), (Object)newExecCnt);
            try {
                this.clock.waitUntil(this.clock.getTime() + TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                LOG.info("Thread interrupted", e);
                Thread.currentThread().interrupt();
                break;
            }
        }
        return origIndexLaneToExecutinoCountMap.isEmpty();
    }

    private void markCurrentIndexFilesUnsafeForActiveDeletion() throws CommitFailedException {
        NodeBuilder rootBuilder = this.store.getRoot().builder();
        for (String indexPath : this.indexPathService.getIndexPaths()) {
            this.markCurrentIndexFilesUnsafeForActiveDeletionFor(rootBuilder, indexPath);
        }
        this.store.merge(rootBuilder, EmptyHook.INSTANCE, CommitInfo.EMPTY);
    }

    private void markCurrentIndexFilesUnsafeForActiveDeletionFor(NodeBuilder rootBuilder, String indexPath) {
        NodeBuilder indexPathBuilder = ActiveDeletedBlobCollectorMBeanImpl.getBuilderForPath(rootBuilder, indexPath);
        if (!"lucene".equals(indexPathBuilder.getProperty("type").getValue(Type.STRING))) {
            LOG.debug("Ignoring index {} as it's not a lucene index", (Object)indexPath);
            return;
        }
        NodeBuilder dataNodeBuilder = indexPathBuilder.getChildNode(":data");
        for (String indexFileName : dataNodeBuilder.getChildNodeNames()) {
            NodeBuilder indexFileBuilder = dataNodeBuilder.getChildNode(indexFileName);
            indexFileBuilder.setProperty("unsafeForActiveDeletion", true);
        }
    }

    private static NodeBuilder getBuilderForPath(NodeBuilder rootBuilder, String path) {
        NodeBuilder builder = rootBuilder;
        for (String elem : PathUtils.elements(path)) {
            builder = builder.getChildNode(elem);
        }
        return builder;
    }

    private long getSafeTimestampForDeletedBlobs() {
        long timestamp = this.clock.getTime() - TimeUnit.SECONDS.toMillis(this.MIN_BLOB_AGE_TO_ACTIVELY_DELETE);
        long minCheckpointTimestamp = this.getOldestCheckpointCreationTimestamp();
        if (minCheckpointTimestamp == -1L) {
            return minCheckpointTimestamp;
        }
        if (minCheckpointTimestamp < timestamp) {
            LOG.info("Oldest checkpoint timestamp ({}) is older than buffer period ({}) for deleted blobs. Using that instead", (Object)minCheckpointTimestamp, (Object)timestamp);
            timestamp = minCheckpointTimestamp;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getOldestCheckpointCreationTimestamp() {
        Tracker<CheckpointMBean> tracker = this.whiteboard.track(CheckpointMBean.class);
        try {
            List<CheckpointMBean> services = tracker.getServices();
            if (services.size() == 1) {
                long l = services.get(0).getOldestCheckpointCreationTimestamp();
                return l;
            }
            if (services.isEmpty()) {
                LOG.warn("Unable to get checkpoint mbean. No service of required type found.");
                long l = -1L;
                return l;
            }
            LOG.warn("Unable to get checkpoint mbean. Multiple services of required type found.");
            long l = -1L;
            return l;
        }
        finally {
            tracker.stop();
        }
    }
}

