/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.jackrabbit.guava.common.base.Suppliers;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyValues;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.filter.PathFilter;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyIndexEditor
implements IndexEditor {
    private static final Logger log = LoggerFactory.getLogger(PropertyIndexEditor.class);
    private final PropertyIndexEditor parent;
    private final String name;
    private String path;
    private final NodeBuilder definition;
    private final NodeState root;
    private final Set<String> propertyNames;
    private final ValuePattern valuePattern;
    private final Predicate<NodeState> typePredicate;
    private final Set<String> keysToCheckForUniqueness;
    private boolean typeChanged;
    private Set<String> beforeKeys;
    private Set<String> afterKeys;
    private final IndexUpdateCallback updateCallback;
    private final PathFilter pathFilter;
    private final PathFilter.Result pathFilterResult;
    private final MountInfoProvider mountInfoProvider;

    public PropertyIndexEditor(NodeBuilder definition, NodeState root, IndexUpdateCallback updateCallback, MountInfoProvider mountInfoProvider) {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.definition = definition;
        this.root = root;
        this.pathFilter = PathFilter.from(definition);
        this.pathFilterResult = this.getPathFilterResult();
        PropertyState names = definition.getProperty("propertyNames");
        this.propertyNames = names.count() == 1 ? Collections.singleton(names.getValue(Type.NAME, 0)) : CollectionUtils.toSet(names.getValue(Type.NAMES));
        this.valuePattern = new ValuePattern(definition);
        this.typePredicate = definition.hasProperty("declaringNodeTypes") ? new TypePredicate(root, definition.getNames("declaringNodeTypes")) : null;
        this.keysToCheckForUniqueness = definition.getBoolean("unique") ? new HashSet<String>() : null;
        this.updateCallback = updateCallback;
        this.mountInfoProvider = mountInfoProvider;
    }

    PropertyIndexEditor(PropertyIndexEditor parent, String name, PathFilter.Result pathFilterResult) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.definition = parent.definition;
        this.root = parent.root;
        this.propertyNames = parent.getPropertyNames();
        this.valuePattern = parent.valuePattern;
        this.typePredicate = parent.typePredicate;
        this.keysToCheckForUniqueness = parent.keysToCheckForUniqueness;
        this.updateCallback = parent.updateCallback;
        this.pathFilter = parent.pathFilter;
        this.pathFilterResult = pathFilterResult;
        this.mountInfoProvider = parent.mountInfoProvider;
    }

    Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    private String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    private static Set<String> addValueKeys(Set<String> keys, PropertyState property, ValuePattern pattern) {
        if (property.getType().tag() != 2 && property.count() > 0) {
            if (keys == null) {
                keys = new HashSet<String>();
            }
            keys.addAll(PropertyIndexUtil.encode(PropertyValues.create(property), pattern));
        }
        return keys;
    }

    private static Set<String> getMatchingKeys(NodeState state, Iterable<String> propertyNames, ValuePattern pattern) {
        Set<String> keys = null;
        for (String propertyName : propertyNames) {
            PropertyState property = state.getProperty(propertyName);
            if (property == null) continue;
            keys = PropertyIndexEditor.addValueKeys(keys, property, pattern);
        }
        return keys;
    }

    Set<IndexStoreStrategy> getStrategies(boolean unique) {
        return Multiplexers.getStrategies(unique, this.mountInfoProvider, this.definition, ":index");
    }

    @Override
    public void enter(NodeState before, NodeState after) {
        this.typeChanged = this.typePredicate == null;
        this.beforeKeys = null;
        this.afterKeys = null;
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        if (this.pathFilterResult == PathFilter.Result.INCLUDE) {
            this.applyTypeRestrictions(before, after);
            this.updateIndex(before, after);
        }
        this.checkUniquenessConstraints();
    }

    private void applyTypeRestrictions(NodeState before, NodeState after) {
        if (this.typePredicate != null) {
            if (this.typeChanged) {
                this.beforeKeys = PropertyIndexEditor.getMatchingKeys(before, this.getPropertyNames(), this.valuePattern);
                this.afterKeys = PropertyIndexEditor.getMatchingKeys(after, this.getPropertyNames(), this.valuePattern);
            }
            if (this.beforeKeys != null && !this.typePredicate.test(before)) {
                this.beforeKeys = null;
            }
            if (this.afterKeys != null && !this.typePredicate.test(after)) {
                this.afterKeys = null;
            }
        }
    }

    private void updateIndex(NodeState before, NodeState after) throws CommitFailedException {
        if (this.beforeKeys != null || this.afterKeys != null) {
            if (this.beforeKeys == null || this.typePredicate != null && !this.typePredicate.test(before)) {
                this.beforeKeys = new HashSet<String>();
            } else if (this.afterKeys == null) {
                this.afterKeys = new HashSet<String>();
            } else {
                HashSet<String> sharedKeys = new HashSet<String>(this.beforeKeys);
                sharedKeys.retainAll(this.afterKeys);
                this.beforeKeys.removeAll(sharedKeys);
                this.afterKeys.removeAll(sharedKeys);
            }
            if (!this.beforeKeys.isEmpty() || !this.afterKeys.isEmpty()) {
                this.updateCallback.indexUpdate();
                String properties = this.definition.getString("propertyNames");
                boolean uniqueIndex = this.keysToCheckForUniqueness != null;
                for (IndexStoreStrategy strategy : this.getStrategies(uniqueIndex)) {
                    String indexNodeName = strategy.getIndexNodeName();
                    org.apache.jackrabbit.guava.common.base.Supplier index = Suppliers.memoize(() -> this.definition.child(indexNodeName));
                    if (uniqueIndex) {
                        Object roBuilder = this.definition.hasChildNode(indexNodeName) ? index : () -> EmptyNodeState.EMPTY_NODE.builder();
                        this.keysToCheckForUniqueness.addAll(this.getExistingKeys(this.afterKeys, (Supplier<NodeBuilder>)roBuilder, strategy));
                    }
                    strategy.update((Supplier<NodeBuilder>)index, this.getPath(), properties, this.definition, this.beforeKeys, this.afterKeys);
                }
            }
        }
        this.checkUniquenessConstraints();
    }

    private void checkUniquenessConstraints() throws CommitFailedException {
        if (this.parent == null) {
            NodeState indexMeta;
            String failed;
            boolean uniqueIndex;
            this.definition.child(":index");
            boolean bl = uniqueIndex = this.keysToCheckForUniqueness != null;
            if (uniqueIndex && !this.keysToCheckForUniqueness.isEmpty() && (failed = this.getFirstDuplicate(this.keysToCheckForUniqueness, indexMeta = this.definition.getNodeState())) != null) {
                String msg = String.format("Uniqueness constraint violated property %s having value %s", this.propertyNames, failed);
                log.warn("checkUniquenessConstraints: {}", (Object)msg);
                throw new CommitFailedException("Constraint", 30, msg);
            }
        }
    }

    private Set<String> getExistingKeys(Set<String> keys, Supplier<NodeBuilder> index, IndexStoreStrategy s) {
        Set<String> existing = null;
        for (String key : keys) {
            if (!s.exists(index, key)) continue;
            if (existing == null) {
                existing = new HashSet<String>();
            }
            existing.add(key);
        }
        if (existing == null) {
            existing = Collections.emptySet();
        }
        return existing;
    }

    private String getFirstDuplicate(Set<String> keys, NodeState indexMeta) {
        for (String key : keys) {
            long count = 0L;
            for (IndexStoreStrategy s : this.getStrategies(true)) {
                if ((count += s.count(this.root, indexMeta, Collections.singleton(key), 2)) <= 1L) continue;
                Iterator<String> it = s.query(null, null, indexMeta, Collections.singleton(key)).iterator();
                if (it.hasNext()) {
                    return key + ": " + it.next();
                }
                return key;
            }
        }
        return null;
    }

    private static boolean isTypeProperty(String name) {
        return "jcr:primaryType".equals(name) || "jcr:mixinTypes".equals(name);
    }

    @Override
    public void propertyAdded(PropertyState after) {
        String name = after.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.afterKeys = PropertyIndexEditor.addValueKeys(this.afterKeys, after, this.valuePattern);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        String name = after.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.beforeKeys = PropertyIndexEditor.addValueKeys(this.beforeKeys, before, this.valuePattern);
            this.afterKeys = PropertyIndexEditor.addValueKeys(this.afterKeys, after, this.valuePattern);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        String name = before.getName();
        boolean bl = this.typeChanged = this.typeChanged || PropertyIndexEditor.isTypeProperty(name);
        if (this.getPropertyNames().contains(name)) {
            this.beforeKeys = PropertyIndexEditor.addValueKeys(this.beforeKeys, before, this.valuePattern);
        }
    }

    PropertyIndexEditor getChildIndexEditor(@NotNull PropertyIndexEditor parent, @NotNull String name, PathFilter.Result filterResult) {
        return new PropertyIndexEditor(parent, name, filterResult);
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        return this.getChildIndexEditor(this, name, filterResult);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        return this.getChildIndexEditor(this, name, filterResult);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) {
        PathFilter.Result filterResult = this.getPathFilterResult(name);
        if (filterResult == PathFilter.Result.EXCLUDE) {
            return null;
        }
        return this.getChildIndexEditor(this, name, filterResult);
    }

    private PathFilter.Result getPathFilterResult() {
        return this.pathFilter.filter(this.getPath());
    }

    private PathFilter.Result getPathFilterResult(String childNodeName) {
        return this.pathFilter.filter(PathUtils.concat(this.getPath(), childNodeName));
    }
}

