/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePatternUtil;

public class PropertyIndexUtil {
    private static final int MAX_STRING_LENGTH = 100;
    private static final String EMPTY_TOKEN = ":";

    public static Set<String> encode(PropertyValue value, ValuePattern pattern) {
        return PropertyIndexUtil.encode(ValuePatternUtil.read(value, pattern));
    }

    public static Set<String> encode(Set<String> set) {
        if (set == null || set.isEmpty()) {
            return set;
        }
        try {
            HashSet<String> values = new HashSet<String>();
            for (String v : set) {
                if (v.length() > 100) {
                    v = v.substring(0, 100);
                }
                v = v.isEmpty() ? EMPTY_TOKEN : URLEncoder.encode(v, StandardCharsets.UTF_8.name());
                values.add(v);
            }
            return values;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is unsupported", e);
        }
    }
}

