/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.resource;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceUtil {
    @Nullable
    public static String normalize(@NotNull String path) {
        int startPos;
        if ((path = ResourceUtil.removeTrailingSlashes(path)).isEmpty() || "/".equals(path)) {
            return path;
        }
        for (startPos = 0; startPos < path.length() && path.charAt(startPos) == '/'; ++startPos) {
        }
        String[] parts = path.substring(startPos).split("/");
        String[] newParts = new String[parts.length];
        int newPartsPos = 0;
        for (String part : parts) {
            int dotCount = ResourceUtil.countDotsSegment(part);
            if (part.isEmpty() || dotCount == 1) continue;
            if (dotCount == 2) {
                if (newPartsPos == 0) {
                    return null;
                }
                --newPartsPos;
                continue;
            }
            if (dotCount > 2) {
                return null;
            }
            newParts[newPartsPos++] = part;
        }
        if (newPartsPos == newParts.length && startPos < 2) {
            return path;
        }
        if (newPartsPos == 0 && startPos > 0) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < newPartsPos; ++i) {
            if (i > 0 || startPos > 0) {
                sb.append('/');
            }
            sb.append(newParts[i]);
        }
        return sb.toString();
    }

    private static String removeTrailingSlashes(@NotNull String path) {
        int endPos;
        for (endPos = path.length() - 1; endPos >= 0 && path.charAt(endPos) == '/'; --endPos) {
        }
        if (endPos == path.length() - 1) {
            return path;
        }
        if (endPos == -1) {
            return "/";
        }
        return path.substring(0, endPos + 1);
    }

    private static int countDotsSegment(String segment) {
        for (int i = 0; i < segment.length(); ++i) {
            if (segment.charAt(i) == '.') continue;
            return 0;
        }
        return segment.length();
    }

    @Nullable
    public static String getParent(@NotNull String path) {
        int lastSlash;
        if ("/".equals(path)) {
            return null;
        }
        if ((path = ResourceUtil.normalize(path)) == null || "/".equals(path)) {
            return null;
        }
        String workspaceName = null;
        int wsSepPos = path.indexOf(":/");
        if (wsSepPos != -1) {
            workspaceName = path.substring(0, wsSepPos);
            path = path.substring(wsSepPos + 1);
        }
        if ((lastSlash = path.lastIndexOf(47)) < 0) {
            return null;
        }
        if (lastSlash == 0) {
            if (workspaceName != null) {
                return workspaceName + ":/";
            }
            return "/";
        }
        String parentPath = path.substring(0, lastSlash);
        if (workspaceName != null) {
            return workspaceName + ":" + parentPath;
        }
        return parentPath;
    }

    public static String getParent(String path, int level) {
        if (level < 0) {
            throw new IllegalArgumentException("level must be non-negative");
        }
        String result = path;
        for (int i = 0; i < level && (result = ResourceUtil.getParent(result)) != null; ++i) {
        }
        return result;
    }

    @Deprecated
    @Nullable
    public static Resource getParent(@NotNull Resource rsrc) {
        return rsrc.getParent();
    }

    @Deprecated
    @NotNull
    public static String getName(@NotNull Resource rsrc) {
        return ResourceUtil.getName(rsrc.getPath());
    }

    @NotNull
    public static String getName(@NotNull String path) {
        if ("/".equals(path)) {
            return "";
        }
        if ("/".equals(path = ResourceUtil.normalize(path))) {
            return "";
        }
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public static boolean isSyntheticResource(@NotNull Resource res) {
        if (res instanceof SyntheticResource) {
            return true;
        }
        if (!(res instanceof ResourceWrapper)) {
            return false;
        }
        while ((res = ((ResourceWrapper)res).getResource()) instanceof ResourceWrapper) {
        }
        return res instanceof SyntheticResource;
    }

    public static boolean isStarResource(@NotNull Resource res) {
        return res.getPath().endsWith("/*");
    }

    public static boolean isNonExistingResource(@NotNull Resource res) {
        return "sling:nonexisting".equals(res.getResourceType());
    }

    @Deprecated
    @NotNull
    public static Iterator<Resource> listChildren(@NotNull Resource parent) {
        return parent.getResourceResolver().listChildren(parent);
    }

    @NotNull
    public static ValueMap getValueMap(Resource res) {
        if (res == null) {
            return new ValueMapDecorator(new HashMap<String, Object>());
        }
        return res.getValueMap();
    }

    @NotNull
    public static String resourceTypeToPath(@NotNull String type) {
        return type.replace(':', '/');
    }

    @Deprecated
    @Nullable
    public static String getResourceSuperType(@NotNull ResourceResolver resourceResolver, String resourceType) {
        return resourceResolver.getParentResourceType(resourceType);
    }

    @Deprecated
    @Nullable
    public static String findResourceSuperType(@NotNull Resource resource) {
        if (resource == null) {
            return null;
        }
        return resource.getResourceResolver().getParentResourceType(resource);
    }

    @Deprecated
    public static boolean isA(@NotNull Resource resource, String resourceType) {
        if (resource == null) {
            return false;
        }
        return resource.getResourceResolver().isResourceType(resource, resourceType);
    }

    @NotNull
    public static <T> Iterator<T> adaptTo(final @NotNull Iterator<Resource> iterator, final Class<T> type) {
        return new Iterator<T>(){
            private T nextObject = this.seek();

            @Override
            public boolean hasNext() {
                return this.nextObject != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = this.nextObject;
                this.nextObject = this.seek();
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private T seek() {
                Object result = null;
                while (result == null && iterator.hasNext()) {
                    Resource r = (Resource)iterator.next();
                    result = r.adaptTo(type);
                }
                return result;
            }
        };
    }

    @NotNull
    public static Resource getOrCreateResource(@NotNull ResourceResolver resolver, @NotNull String path, String resourceType, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Map<String, Object> props = resourceType == null ? null : Collections.singletonMap("sling:resourceType", resourceType);
        return ResourceUtil.getOrCreateResource(resolver, path, props, intermediateResourceType, autoCommit);
    }

    @NotNull
    public static Resource getOrCreateResource(@NotNull ResourceResolver resolver, @NotNull String path, Map<String, Object> resourceProperties, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        PersistenceException mostRecentPE = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return ResourceUtil.getOrCreateResourceInternal(resolver, path, resourceProperties, intermediateResourceType, autoCommit);
            }
            catch (PersistenceException pe) {
                if (!autoCommit) {
                    throw pe;
                }
                resolver.revert();
                resolver.refresh();
                mostRecentPE = pe;
                continue;
            }
        }
        throw mostRecentPE;
    }

    private static Resource getOrCreateResourceInternal(ResourceResolver resolver, String path, Map<String, Object> resourceProperties, String intermediateResourceType, boolean autoCommit) throws PersistenceException {
        Resource rsrc;
        block12: {
            rsrc = resolver.getResource(path);
            if (rsrc == null) {
                Resource parentResource;
                String name;
                block11: {
                    int lastPos = path.lastIndexOf(47);
                    name = path.substring(lastPos + 1);
                    if (lastPos == 0) {
                        parentResource = resolver.getResource("/");
                    } else {
                        String parentPath = path.substring(0, lastPos);
                        parentResource = ResourceUtil.getOrCreateResource(resolver, parentPath, intermediateResourceType, intermediateResourceType, autoCommit);
                    }
                    if (autoCommit) {
                        resolver.refresh();
                    }
                    try {
                        for (int retry = 5; retry > 0 && rsrc == null; --retry) {
                            rsrc = resolver.create(parentResource, name, resourceProperties);
                            if (name.equals(rsrc.getName())) continue;
                            resolver.refresh();
                            resolver.delete(rsrc);
                            rsrc = resolver.getResource(parentResource, name);
                        }
                        if (rsrc == null) {
                            throw new PersistenceException("Unable to create resource.");
                        }
                    }
                    catch (PersistenceException pe) {
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block11;
                        throw pe;
                    }
                }
                if (autoCommit) {
                    try {
                        resolver.commit();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                    }
                    catch (PersistenceException pe) {
                        resolver.revert();
                        resolver.refresh();
                        rsrc = resolver.getResource(parentResource, name);
                        if (rsrc != null) break block12;
                        rsrc = resolver.create(parentResource, name, resourceProperties);
                        resolver.commit();
                    }
                }
            }
        }
        return rsrc;
    }

    public static String createUniqueChildName(Resource parent, String name) throws PersistenceException {
        if (parent.getChild(name) != null) {
            String childNodeName = null;
            int i = 0;
            do {
                childNodeName = name + String.valueOf(i);
                if (i == Integer.MAX_VALUE) {
                    String message = MessageFormat.format("can not find a unique name {0} for {1}", name, parent.getPath());
                    throw new PersistenceException(message);
                }
                ++i;
            } while (parent.getChild(childNodeName) != null);
            return childNodeName;
        }
        return name;
    }

    @NotNull
    public static Resource unwrap(@NotNull Resource rsrc) {
        Resource result = rsrc;
        while (result instanceof ResourceWrapper) {
            result = ((ResourceWrapper)result).getResource();
        }
        return result;
    }

    @NotNull
    public static BatchResourceRemover getBatchResourceRemover(int threshold) {
        return new BatchResourceRemover(threshold);
    }

    public static class BatchResourceRemover {
        private final int max;
        private int count;

        public BatchResourceRemover(int batchSize) {
            this.max = batchSize < 1 ? 50 : batchSize;
        }

        public void delete(@NotNull Resource rsrc) throws PersistenceException {
            ResourceResolver resolver = rsrc.getResourceResolver();
            for (Resource child : rsrc.getChildren()) {
                this.delete(child);
            }
            resolver.delete(rsrc);
            ++this.count;
            if (this.count >= this.max) {
                resolver.commit();
                this.count = 0;
            }
        }
    }
}

