/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.osgi.util.converter.AbstractSpecifying;
import org.osgi.util.converter.ConversionException;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;
import org.osgi.util.converter.DTOUtil;
import org.osgi.util.converter.InternalConverter;
import org.osgi.util.converter.InternalConverting;
import org.osgi.util.converter.ListDelegate;
import org.osgi.util.converter.MapDelegate;
import org.osgi.util.converter.SetDelegate;
import org.osgi.util.converter.TypeReference;
import org.osgi.util.converter.Util;

class ConvertingImpl
extends AbstractSpecifying<Converting>
implements Converting,
InternalConverting {
    private static final Map<Class<?>, Class<?>> INTERFACE_IMPLS;
    private static final Collection<Class<?>> NO_MAP_VIEW_TYPES;
    private final InternalConverter initialConverter;
    private volatile Object object;
    private volatile Class<?> sourceClass;
    private volatile Class<?> targetClass;
    private volatile Type[] typeArguments;
    private volatile Type targetType;

    private static void addClassIfAvailable(String cls, Collection<Class<?>> collection) {
        try {
            Class<?> clazz = ConvertingImpl.class.getClassLoader().loadClass(cls);
            collection.add(clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    ConvertingImpl(InternalConverter converter, Object obj) {
        this.initialConverter = converter;
        this.object = obj;
    }

    @Override
    public <T> T to(Class<T> cls) {
        Class<T> type = cls;
        return this.to((Type)type);
    }

    @Override
    public <T> T to(TypeReference<T> ref) {
        return this.to(ref.getType());
    }

    @Override
    public <T> T to(Type type) {
        return this.to(type, this.initialConverter);
    }

    @Override
    public <T> T to(Type type, InternalConverter converter) {
        Type rt;
        Type pt;
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] lowerBounds = wt.getLowerBounds();
            if (lowerBounds.length != 0) {
                throw new ConversionException("The type variable " + wt.toString() + " cannot be used with the converter. The use of <? super ...> is highly ambiguous.");
            }
            type = wt.getUpperBounds()[0];
        }
        Class cls = null;
        if (type instanceof Class) {
            cls = (Class)type;
        } else if (type instanceof ParameterizedType) {
            pt = (ParameterizedType)type;
            rt = pt.getRawType();
            this.typeArguments = pt.getActualTypeArguments();
            if (rt instanceof Class) {
                cls = (Class)rt;
            }
        } else if (type instanceof GenericArrayType) {
            Type rt2;
            pt = (GenericArrayType)type;
            rt = pt.getGenericComponentType();
            if (rt instanceof Class) {
                cls = (Class)rt;
            } else if (rt instanceof ParameterizedType && (rt2 = ((ParameterizedType)rt).getRawType()) instanceof Class) {
                cls = (Class)rt2;
            }
        }
        this.targetType = type;
        if (cls == null) {
            return null;
        }
        if (this.object == null) {
            return (T)this.handleNull(cls, converter);
        }
        this.targetClass = Util.primitiveToBoxed(cls);
        if (this.targetAsClass == null) {
            this.targetAsClass = this.targetClass;
        }
        Class<?> clazz = this.sourceClass = this.sourceAsClass != null ? this.sourceAsClass : this.object.getClass();
        if (!ConvertingImpl.isCopyRequiredType(this.targetAsClass) && this.targetAsClass.isAssignableFrom(this.sourceClass)) {
            return (T)this.object;
        }
        Object res = this.trySpecialCases(converter);
        if (res != null) {
            return (T)res;
        }
        if (this.targetAsClass.isArray()) {
            return this.convertToArray(this.targetAsClass.getComponentType(), this.targetAsClass.getComponentType(), converter);
        }
        if (type instanceof GenericArrayType) {
            return this.convertToArray(this.targetAsClass, ((GenericArrayType)type).getGenericComponentType(), converter);
        }
        if (Collection.class.isAssignableFrom(this.targetAsClass)) {
            return this.convertToCollectionType(converter);
        }
        if (ConvertingImpl.isMapType(this.targetAsClass, this.targetAsJavaBean, this.targetAsDTO)) {
            return (T)this.convertToMapType(converter);
        }
        if (Collection.class.isAssignableFrom(this.sourceClass)) {
            return (T)this.convertCollectionToSingleValue(this.targetAsClass, converter);
        }
        if (ConvertingImpl.isMapType(this.sourceClass, this.sourceAsJavaBean, this.sourceAsDTO)) {
            return (T)this.convertMapToSingleValue(this.targetAsClass, converter);
        }
        if (this.object instanceof Map.Entry) {
            return (T)this.convertMapEntryToSingleValue(this.targetAsClass, converter);
        }
        this.object = ConvertingImpl.asBoxedArray(this.object);
        if (this.object instanceof Object[]) {
            return (T)this.convertArrayToSingleValue(this.targetAsClass, converter);
        }
        T res2 = this.tryStandardMethods();
        if (res2 != null) {
            return res2;
        }
        if (this.hasDefault) {
            return (T)((Converting)((Converting)converter.convert(this.defaultValue).sourceAs(this.sourceAsClass)).targetAs(this.targetAsClass)).to(this.targetClass);
        }
        throw new ConversionException("Cannot convert " + this.object + " to " + this.targetAsClass);
    }

    private Object convertArrayToSingleValue(Class<?> cls, InternalConverter converter) {
        Object[] arr = (Object[])this.object;
        if (arr.length == 0) {
            return null;
        }
        return converter.convert(arr[0]).to(cls);
    }

    private Object convertCollectionToSingleValue(Class<?> cls, InternalConverter converter) {
        Collection coll = (Collection)this.object;
        if (coll.size() == 0) {
            return null;
        }
        return converter.convert(coll.iterator().next()).to(cls);
    }

    private Object convertMapToSingleValue(Class<?> cls, InternalConverter converter) {
        Map<?, ?> m = this.mapView(this.object, this.sourceClass, converter);
        if (m.size() > 0) {
            return converter.convert(m.entrySet().iterator().next()).to(cls);
        }
        return null;
    }

    private Object convertMapEntryToSingleValue(Class<?> cls, InternalConverter converter) {
        Class<?> valueCls;
        Map.Entry entry = (Map.Entry)this.object;
        Class<?> keyCls = entry.getKey() != null ? entry.getKey().getClass() : null;
        Class<?> clazz = valueCls = entry.getValue() != null ? entry.getValue().getClass() : null;
        if (cls.equals(keyCls)) {
            return converter.convert(entry.getKey()).to(cls);
        }
        if (cls.equals(valueCls)) {
            return converter.convert(entry.getValue()).to(cls);
        }
        if (keyCls != null && cls.isAssignableFrom(keyCls)) {
            return converter.convert(entry.getKey()).to(cls);
        }
        if (valueCls != null && cls.isAssignableFrom(valueCls)) {
            return converter.convert(entry.getValue()).to(cls);
        }
        if (entry.getKey() instanceof String) {
            return converter.convert(entry.getKey()).to(cls);
        }
        if (entry.getValue() instanceof String) {
            return converter.convert(entry.getValue()).to(cls);
        }
        return converter.convert(converter.convert(entry.getKey()).to(String.class)).to(cls);
    }

    private <T> T convertToArray(Class<?> componentClz, Type componentType, InternalConverter converter) {
        Collection<?> collectionView = this.collectionView(converter);
        Iterator<?> iterator = collectionView.iterator();
        try {
            Object array = Array.newInstance(componentClz, collectionView.size());
            for (int i = 0; i < collectionView.size() && iterator.hasNext(); ++i) {
                Object next = iterator.next();
                Object converted = converter.convert(next).to(componentType);
                Array.set(array, i, converted);
            }
            return (T)array;
        }
        catch (Exception e) {
            throw new ConversionException("Cannot iterate over " + collectionView.getClass(), e);
        }
    }

    private <T> T convertToCollectionType(InternalConverter converter) {
        Collection<?> res = this.convertToCollectionDelegate(converter);
        if (res != null) {
            return (T)res;
        }
        return this.convertToCollection(converter);
    }

    private Collection<?> convertToCollectionDelegate(InternalConverter converter) {
        if (!this.liveView) {
            return null;
        }
        if (List.class.equals(this.targetClass) || Collection.class.equals(this.targetClass)) {
            if (this.sourceClass.isArray()) {
                return ListDelegate.forArray(this.object, this, converter);
            }
            if (Collection.class.isAssignableFrom(this.sourceClass)) {
                return ListDelegate.forCollection((Collection)this.object, this, converter);
            }
        } else if (Set.class.equals(this.targetClass)) {
            if (this.sourceClass.isArray()) {
                return SetDelegate.forCollection(ListDelegate.forArray(this.object, this, converter), this, converter);
            }
            if (Collection.class.isAssignableFrom(this.sourceClass)) {
                return SetDelegate.forCollection((Collection)this.object, this, converter);
            }
        }
        return null;
    }

    private <T> T convertToCollection(InternalConverter converter) {
        Class ctrCls;
        Class targetCls;
        Collection instance;
        Collection<?> cv = this.collectionView(converter);
        Class targetElementType = null;
        if (this.typeArguments != null && this.typeArguments.length > 0 && this.typeArguments[0] instanceof Class) {
            targetElementType = (Class)this.typeArguments[0];
        }
        if ((instance = (Collection)ConvertingImpl.createMapOrCollection(targetCls = (ctrCls = INTERFACE_IMPLS.get(this.targetAsClass)) != null ? ctrCls : this.targetAsClass, cv.size())) == null) {
            return null;
        }
        for (Object o : cv) {
            block6: {
                if (targetElementType != null) {
                    try {
                        o = converter.convert(o).to(targetElementType);
                    }
                    catch (ConversionException ce) {
                        if (!this.hasDefault) break block6;
                        return (T)this.defaultValue;
                    }
                }
            }
            instance.add(o);
        }
        return (T)instance;
    }

    private <T> T convertToDTO(Class<?> sourceCls, Class<?> targetAsCls, InternalConverter converter) {
        Map<?, ?> m = this.mapView(this.object, sourceCls, converter);
        try {
            String prefix = Util.getPrefix(targetAsCls);
            Object dto = this.targetClass.newInstance();
            List<String> names = this.getNames(this.targetAsClass);
            for (Map.Entry<?, ?> entry : m.entrySet()) {
                Field f;
                block9: {
                    String fieldName;
                    Object key = entry.getKey();
                    if (key == null || (fieldName = Util.mangleName(prefix, key.toString(), names)) == null) continue;
                    f = null;
                    try {
                        f = targetAsCls.getField(fieldName);
                    }
                    catch (NoSuchFieldException e) {
                        if (!this.keysIgnoreCase) break block9;
                        for (Field fs : targetAsCls.getFields()) {
                            if (!fs.getName().equalsIgnoreCase(fieldName)) continue;
                            f = fs;
                            break;
                        }
                        if (f != null) break block9;
                        for (Field fs : targetAsCls.getFields()) {
                            if (!fs.getName().equalsIgnoreCase(fieldName)) continue;
                            f = fs;
                            break;
                        }
                    }
                }
                if (f == null) continue;
                Object val = entry.getValue();
                if (this.sourceAsDTO && DTOUtil.isDTOType(f.getType(), false)) {
                    val = ((Converting)converter.convert(val).sourceAsDTO()).to(f.getType());
                } else {
                    Type genericType = ConvertingImpl.reifyType(f.getGenericType(), this.targetAsClass, this.typeArguments);
                    val = converter.convert(val).to(genericType);
                }
                f.set(dto, val);
            }
            return (T)dto;
        }
        catch (Exception e) {
            throw new ConversionException("Cannot create DTO " + this.targetClass, e);
        }
    }

    static Type reifyType(Type typeToReify, Class<?> ownerClass, Type[] typeArgs) {
        GenericArrayType type;
        Type genericComponentType;
        Type reifiedType;
        if (typeToReify instanceof TypeVariable) {
            String name = ((TypeVariable)typeToReify).getName();
            for (int i = 0; i < ownerClass.getTypeParameters().length; ++i) {
                TypeVariable<Class<?>> typeVariable = ownerClass.getTypeParameters()[i];
                if (!typeVariable.getName().equals(name)) continue;
                return typeArgs[i];
            }
            Type currentType = ownerClass;
            while (currentType != null) {
                ParameterizedType pt;
                Type rawType;
                if (currentType instanceof Class) {
                    currentType = currentType.getGenericSuperclass();
                } else if (currentType instanceof ParameterizedType) {
                    currentType = ((ParameterizedType)currentType).getRawType();
                }
                if (!(currentType instanceof ParameterizedType) || !((rawType = (pt = (ParameterizedType)currentType).getRawType()) instanceof Class)) continue;
                return ConvertingImpl.reifyType(typeToReify, (Class)rawType, pt.getActualTypeArguments());
            }
        } else if (typeToReify instanceof ParameterizedType) {
            final ParameterizedType parameterizedType = (ParameterizedType)typeToReify;
            Type[] parameters = parameterizedType.getActualTypeArguments();
            boolean useCopy = false;
            final Type[] copiedParameters = new Type[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                copiedParameters[i] = ConvertingImpl.reifyType(parameters[i], ownerClass, typeArgs);
                useCopy |= copiedParameters[i] != parameters[i];
            }
            if (useCopy) {
                return new ParameterizedType(){

                    @Override
                    public Type getRawType() {
                        return parameterizedType.getRawType();
                    }

                    @Override
                    public Type getOwnerType() {
                        return parameterizedType.getOwnerType();
                    }

                    @Override
                    public Type[] getActualTypeArguments() {
                        return Arrays.copyOf(copiedParameters, copiedParameters.length);
                    }
                };
            }
        } else if (typeToReify instanceof GenericArrayType && (reifiedType = ConvertingImpl.reifyType(genericComponentType = (type = (GenericArrayType)typeToReify).getGenericComponentType(), ownerClass, typeArgs)) != genericComponentType) {
            return new GenericArrayType(){

                @Override
                public Type getGenericComponentType() {
                    return reifiedType;
                }
            };
        }
        return typeToReify;
    }

    private List<String> getNames(Class<?> cls) {
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : cls.getFields()) {
            String name;
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || names.contains(name = field.getName())) continue;
            names.add(name);
        }
        return names;
    }

    private Map convertToMap(InternalConverter converter) {
        Map instance;
        Map<?, ?> m = this.mapView(this.object, this.sourceClass, converter);
        if (m == null) {
            return null;
        }
        Class<?> ctrCls = INTERFACE_IMPLS.get(this.targetClass);
        if (ctrCls == null) {
            ctrCls = this.targetClass;
        }
        if ((instance = (Map)ConvertingImpl.createMapOrCollection(ctrCls, m.size())) == null) {
            return null;
        }
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            key = this.convertMapKey(key, converter);
            value = this.convertMapValue(value, converter);
            instance.put(key, value);
        }
        return instance;
    }

    Object convertCollectionValue(Object element, InternalConverter converter) {
        Type type = null;
        if (this.typeArguments != null && this.typeArguments.length > 0) {
            type = this.typeArguments[0];
        }
        if (element != null) {
            if (type != null) {
                element = converter.convert(element).to(type);
            } else {
                Class<?> cls = element.getClass();
                if (ConvertingImpl.isCopyRequiredType(cls)) {
                    cls = ConvertingImpl.getConstructableType(cls);
                }
                element = this.sourceAsDTO || DTOUtil.isDTOType(cls, true) ? ((Converting)converter.convert(element).sourceAsDTO()).to(cls) : converter.convert(element).to(cls);
            }
        }
        return element;
    }

    Object convertMapKey(Object key, InternalConverter converter) {
        return this.convertMapElement(key, 0, converter);
    }

    Object convertMapValue(Object value, InternalConverter converter) {
        return this.convertMapElement(value, 1, converter);
    }

    private Object convertMapElement(Object element, int typeIdx, InternalConverter converter) {
        Type type = null;
        if (this.typeArguments != null && this.typeArguments.length > typeIdx) {
            type = this.typeArguments[typeIdx];
        }
        if (element != null) {
            if (type != null) {
                element = converter.convert(element).to(type);
            } else {
                Class<?> cls = element.getClass();
                if (ConvertingImpl.isCopyRequiredType(cls)) {
                    cls = ConvertingImpl.getConstructableType(cls);
                }
                element = this.sourceAsDTO || DTOUtil.isDTOType(cls, true) ? ((Converting)converter.convert(element).sourceAsDTO()).to(cls) : converter.convert(element).to(cls);
            }
        }
        return element;
    }

    private Map convertToMapDelegate(InternalConverter converter) {
        if (Map.class.isAssignableFrom(this.sourceClass)) {
            return MapDelegate.forMap((Map)this.object, this, converter);
        }
        if (Dictionary.class.isAssignableFrom(this.sourceClass)) {
            return MapDelegate.forDictionary((Dictionary)this.object, this, converter);
        }
        if (DTOUtil.isDTOType(this.sourceClass, true) || this.sourceAsDTO) {
            return MapDelegate.forDTO(this.object, this.sourceClass, this, converter);
        }
        if (this.sourceAsJavaBean) {
            return MapDelegate.forBean(this.object, this.sourceClass, this, converter);
        }
        if (this.hasGetProperties(this.sourceClass)) {
            return null;
        }
        Set<Class<?>> interfaces = ConvertingImpl.getInterfaces(this.sourceClass);
        if (interfaces.size() > 0) {
            return MapDelegate.forInterface(this.object, interfaces.iterator().next(), this, converter);
        }
        return null;
    }

    private Object convertToMapType(InternalConverter converter) {
        Map res;
        if (!ConvertingImpl.isMapType(this.sourceClass, this.sourceAsJavaBean, this.sourceAsDTO)) {
            throw new ConversionException("Cannot convert " + this.object + " to " + this.targetAsClass);
        }
        if (Map.class.equals(this.targetClass) && this.liveView && (res = this.convertToMapDelegate(converter)) != null) {
            return res;
        }
        if (Map.class.isAssignableFrom(this.targetAsClass)) {
            return this.convertToMap(converter);
        }
        if (Dictionary.class.isAssignableFrom(this.targetAsClass)) {
            return this.convertToDictionary(converter);
        }
        if (this.targetAsDTO || DTOUtil.isDTOType(this.targetAsClass, false)) {
            return this.convertToDTO(this.sourceClass, this.targetAsClass, converter);
        }
        if (this.targetAsClass.isInterface()) {
            return this.convertToInterface(this.sourceClass, this.targetAsClass, converter);
        }
        if (this.targetAsJavaBean) {
            return this.convertToJavaBean(this.sourceClass, this.targetAsClass, converter);
        }
        throw new ConversionException("Cannot convert " + this.object + " to " + this.targetAsClass);
    }

    private Object convertToDictionary(InternalConverter converter) {
        return new Hashtable((Map)converter.convert(this.object).to(new ParameterizedType(){

            @Override
            public Type getRawType() {
                return HashMap.class;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }

            @Override
            public Type[] getActualTypeArguments() {
                return ConvertingImpl.this.typeArguments;
            }
        }));
    }

    private Object convertToJavaBean(Class<?> sourceCls, Class<?> targetCls, InternalConverter converter) {
        String prefix = Util.getPrefix(targetCls);
        Map<?, ?> m = this.mapView(this.object, sourceCls, converter);
        try {
            Object res = this.targetClass.newInstance();
            for (Method setter : ConvertingImpl.getSetters(targetCls)) {
                String setterName = setter.getName();
                StringBuilder propName = new StringBuilder(setterName.length() - 3).append(Character.toLowerCase(setterName.charAt(3))).append(setterName.substring(4));
                Class<?> setterType = setter.getParameterTypes()[0];
                String key = propName.toString();
                Object val = m.get(Util.unMangleName(prefix, key));
                setter.invoke(res, converter.convert(val).to(setterType));
            }
            return res;
        }
        catch (Exception e) {
            throw new ConversionException("Cannot convert to class: " + targetCls.getName() + ". Not a JavaBean with a Zero-arg Constructor.", e);
        }
    }

    private Object convertToInterface(Class<?> sourceCls, Class<?> targetCls, InternalConverter converter) {
        InternalConverting ic = converter.convert(this.object);
        ((Converting)ic.sourceAs(this.sourceAsClass)).view();
        if (this.sourceAsDTO) {
            ic.sourceAsDTO();
        }
        if (this.sourceAsJavaBean) {
            ic.sourceAsBean();
        }
        Map m = ic.to(Map.class);
        return this.createProxy(targetCls, m, converter);
    }

    private Object createProxy(final Class<?> cls, final Map<?, ?> data, final InternalConverter converter) {
        return Proxy.newProxyInstance(cls.getClassLoader(), new Class[]{cls}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> mdDecl = method.getDeclaringClass();
                if (mdDecl.equals(Object.class)) {
                    switch (method.getName()) {
                        case "equals": {
                            return proxy == args[0];
                        }
                        case "hashCode": {
                            return System.identityHashCode(proxy);
                        }
                        case "toString": {
                            return "Proxy for " + cls;
                        }
                    }
                    throw new UnsupportedOperationException("Method " + method + " not supported on proxy for " + cls);
                }
                if (mdDecl.equals(Annotation.class) && "annotationType".equals(method.getName()) && method.getParameterTypes().length == 0) {
                    return cls;
                }
                String propName = Util.getInterfacePropertyName(method, Util.getSingleElementAnnotationKey(cls, proxy), proxy);
                if (propName == null) {
                    throw new ConversionException("Can not convert. Calculated propertyName is `null` method: " + method);
                }
                Object val = null;
                boolean handled = false;
                if (data.containsKey(propName)) {
                    val = data.get(propName);
                    handled = true;
                } else if (val == null && ConvertingImpl.this.keysIgnoreCase) {
                    Iterator it = data.keySet().iterator();
                    while (it.hasNext() && val == null) {
                        String k = it.next().toString();
                        if (!propName.equalsIgnoreCase(k)) continue;
                        val = data.get(k);
                        handled = true;
                        break;
                    }
                }
                if (!handled) {
                    if (cls.isAnnotation()) {
                        val = method.getDefaultValue();
                    } else if (method.isDefault()) {
                        try {
                            double javaVersion = Double.parseDouble(System.getProperty("java.class.version"));
                            double java8 = 52.0;
                            if (javaVersion > java8) {
                                val = MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
                                handled = true;
                            } else {
                                Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
                                if (!constructor.isAccessible()) {
                                    constructor.setAccessible(true);
                                }
                                val = ((MethodHandles.Lookup)constructor.newInstance(cls)).in(cls).unreflectSpecial(method, cls).bindTo(proxy).invokeWithArguments(args);
                                handled = true;
                            }
                        }
                        catch (Exception e) {
                            throw new ConversionException("Can not convert. Exception is thrown in default method: " + method, e);
                        }
                    }
                    if (!handled && val == null) {
                        if (args != null && args.length == 1) {
                            val = args[0];
                        } else {
                            throw new ConversionException("No value for property: " + propName);
                        }
                    }
                }
                Type genericType = ConvertingImpl.reifyType(method.getGenericReturnType(), ConvertingImpl.this.targetAsClass, ConvertingImpl.this.typeArguments);
                return converter.convert(val).to(genericType);
            }
        });
    }

    private Object handleNull(Class<?> cls, InternalConverter converter) {
        if (this.hasDefault) {
            return converter.convert(this.defaultValue).to(cls);
        }
        Class<?> boxed = Util.primitiveToBoxed(cls);
        if (boxed.equals(cls)) {
            if (cls.isArray()) {
                int i = 1;
                Class<?> componentType = cls.getComponentType();
                while (componentType.isArray()) {
                    ++i;
                    componentType = componentType.getComponentType();
                }
                if (i == 1) {
                    return Array.newInstance(componentType, 0);
                }
                return Array.newInstance(componentType, new int[i]);
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return converter.convert(Collections.emptyList()).to(cls);
            }
            return null;
        }
        return converter.convert(0).to(cls);
    }

    private static boolean isMapType(Class<?> cls, boolean asJavaBean, boolean asDTO) {
        if (asDTO) {
            return true;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return true;
        }
        if (Annotation.class.isAssignableFrom(cls)) {
            return true;
        }
        if (ConvertingImpl.getInterfaces(cls).size() > 0) {
            return true;
        }
        if (DTOUtil.isDTOType(cls, true)) {
            return true;
        }
        if (asJavaBean && ConvertingImpl.isWriteableJavaBean(cls)) {
            return true;
        }
        return Dictionary.class.isAssignableFrom(cls);
    }

    private Object trySpecialCases(InternalConverter converter) {
        block24: {
            if (Boolean.class.equals((Object)this.targetAsClass)) {
                if (this.object instanceof Collection && ((Collection)this.object).size() == 0) {
                    return Boolean.FALSE;
                }
            } else if (Number.class.isAssignableFrom(this.targetAsClass)) {
                Number value = this.object instanceof Boolean ? (Number)((Boolean)this.object != false ? Integer.valueOf(1) : Integer.valueOf(0)) : (Number)(this.object instanceof Number ? (Number)((Number)this.object) : (Number)null);
                if (value != null) {
                    if (Byte.class.isAssignableFrom(this.targetAsClass)) {
                        return value.byteValue();
                    }
                    if (Short.class.isAssignableFrom(this.targetAsClass)) {
                        return value.shortValue();
                    }
                    if (Integer.class.isAssignableFrom(this.targetAsClass)) {
                        return value.intValue();
                    }
                    if (Long.class.isAssignableFrom(this.targetAsClass)) {
                        return value.longValue();
                    }
                    if (Float.class.isAssignableFrom(this.targetAsClass)) {
                        return Float.valueOf(value.floatValue());
                    }
                    if (Double.class.isAssignableFrom(this.targetAsClass)) {
                        return value.doubleValue();
                    }
                }
            } else {
                if (this.targetAsClass.isEnum()) {
                    if (this.object instanceof Number) {
                        try {
                            Method m = this.targetAsClass.getMethod("values", new Class[0]);
                            Object[] values = (Object[])m.invoke(null, new Object[0]);
                            return values[((Number)this.object).intValue()];
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                    try {
                        Method m = this.targetAsClass.getMethod("valueOf", String.class);
                        return m.invoke(null, this.object.toString());
                    }
                    catch (Exception e) {
                        try {
                            Method m = this.targetAsClass.getMethod("values", new Class[0]);
                            for (Object v : (Object[])m.invoke(null, new Object[0])) {
                                if (!v.toString().equalsIgnoreCase(this.object.toString())) continue;
                                return v;
                            }
                            break block24;
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                    }
                }
                if (Annotation.class.isAssignableFrom(this.sourceClass) && ConvertingImpl.isMarkerAnnotation(this.sourceClass)) {
                    String key = Util.getMarkerAnnotationKey(this.sourceClass, this.object);
                    return ((Converting)converter.convert(Collections.singletonMap(key, Boolean.TRUE)).targetAs(this.targetAsClass)).to(this.targetType);
                }
                if (Annotation.class.isAssignableFrom(this.targetAsClass) && ConvertingImpl.isMarkerAnnotation(this.targetAsClass)) {
                    Map<String, Boolean> representation = Converters.standardConverter().convert(this.object).to(new TypeReference<Map<String, Boolean>>(){});
                    if (Boolean.TRUE.equals(representation.get(Util.toSingleElementAnnotationKey(this.targetAsClass.getSimpleName())))) {
                        return this.createProxy(this.targetClass, Collections.emptyMap(), converter);
                    }
                    throw new ConversionException("Cannot convert " + this.object + " to marker annotation " + this.targetAsClass);
                }
            }
        }
        return null;
    }

    private static boolean isMarkerAnnotation(Class<?> annClass) {
        for (Method m : annClass.getMethods()) {
            if (m.getDeclaringClass() != annClass) continue;
            return false;
        }
        return true;
    }

    private <T> T tryStandardMethods() {
        try {
            Method m = this.targetAsClass.getMethod("valueOf", String.class);
            if (m != null && Modifier.isStatic(m.getModifiers())) {
                return (T)m.invoke(null, this.object.toString());
            }
        }
        catch (Exception e) {
            try {
                Constructor ctr = this.targetAsClass.getConstructor(String.class);
                return ctr.newInstance(this.object.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Collection<?> collectionView(InternalConverter converter) {
        if (this.object == null) {
            return null;
        }
        Collection<?> c = this.asCollection(converter);
        if (c == null) {
            return Collections.singleton(this.object);
        }
        return c;
    }

    private Collection<?> asCollection(InternalConverter converter) {
        if (this.object instanceof Collection) {
            return (Collection)this.object;
        }
        this.object = ConvertingImpl.asBoxedArray(this.object);
        if (this.object instanceof Object[]) {
            return Arrays.asList((Object[])this.object);
        }
        if (ConvertingImpl.isMapType(this.sourceClass, this.sourceAsJavaBean, this.sourceAsDTO)) {
            return this.mapView(this.object, this.sourceClass, converter).entrySet();
        }
        return null;
    }

    private static Object asBoxedArray(Object obj) {
        Class<?> objClass = obj.getClass();
        if (!objClass.isArray()) {
            return obj;
        }
        int len = Array.getLength(obj);
        Object arr = Array.newInstance(Util.primitiveToBoxed(objClass.getComponentType()), len);
        for (int i = 0; i < len; ++i) {
            Object val = Array.get(obj, i);
            Array.set(arr, i, val);
        }
        return arr;
    }

    private static Map createMapFromBeanAccessors(Object obj, Class<?> sourceCls) {
        HashSet<String> invokedMethods = new HashSet<String>();
        HashMap result = new HashMap();
        for (Method md : sourceCls.getMethods()) {
            ConvertingImpl.handleBeanMethod(obj, md, invokedMethods, result);
        }
        return result;
    }

    private Map createMapFromDTO(Object obj, InternalConverter converter) {
        HashSet<String> handledFields = new HashSet<String>();
        HashMap result = new HashMap();
        for (Field f : obj.getClass().getFields()) {
            this.handleDTOField(obj, f, handledFields, result, converter);
        }
        return result;
    }

    private static Map createMapFromInterface(Object obj, Class<?> srcCls) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        if (Annotation.class.isAssignableFrom(srcCls) && ConvertingImpl.isMarkerAnnotation(((Annotation)obj).annotationType())) {
            result.put(Util.getMarkerAnnotationKey(((Annotation)obj).annotationType(), obj), Boolean.TRUE);
            return result;
        }
        for (Class<?> i : ConvertingImpl.getInterfaces(srcCls)) {
            for (Method md : i.getMethods()) {
                ConvertingImpl.handleInterfaceMethod(obj, i, md, new HashSet<String>(), result);
            }
            if (result.size() <= 0) continue;
            return result;
        }
        throw new ConversionException("Cannot be converted to map: " + obj);
    }

    private static Object createMapOrCollection(Class<?> cls, int initialSize) {
        try {
            Constructor<?> ctor = cls.getConstructor(Integer.TYPE);
            return ctor.newInstance(initialSize);
        }
        catch (Exception e1) {
            try {
                Constructor<?> ctor2 = cls.getConstructor(new Class[0]);
                return ctor2.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private static Class<?> getConstructableType(Class<?> targetCls) {
        if (targetCls.isArray()) {
            return targetCls;
        }
        Class<?> cls = targetCls;
        while (true) {
            try {
                cls.getConstructor(Integer.TYPE);
                return cls;
            }
            catch (NoSuchMethodException e) {
                try {
                    cls.getConstructor(new Class[0]);
                    return cls;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    for (Class<?> intf : cls.getInterfaces()) {
                        Class<?> impl = INTERFACE_IMPLS.get(intf);
                        if (impl == null) continue;
                        return impl;
                    }
                    if (!Object.class.equals(cls = cls.getSuperclass())) continue;
                    return null;
                }
            }
            break;
        }
    }

    private static Set<Class<?>> getInterfaces(Class<?> cls) {
        if (NO_MAP_VIEW_TYPES.contains(cls)) {
            return Collections.emptySet();
        }
        Set<Class<Class<?>>> interfaces = ConvertingImpl.getInterfaces0(cls);
        Iterator<Class<?>> it = interfaces.iterator();
        block0: while (it.hasNext()) {
            Method[] methods;
            Class<?> intf = it.next();
            for (Method method : methods = intf.getMethods()) {
                if (method.getDeclaringClass() == intf) continue block0;
            }
            if (intf == cls && methods.length == 0) continue;
            it.remove();
        }
        interfaces.removeAll(NO_MAP_VIEW_TYPES);
        return interfaces;
    }

    private static Set<Class<?>> getInterfaces0(Class<?> cls) {
        if (cls == null) {
            return Collections.emptySet();
        }
        LinkedHashSet classes = new LinkedHashSet();
        if (cls.isInterface()) {
            classes.add(cls);
        }
        for (Class<?> intf : cls.getInterfaces()) {
            classes.addAll(ConvertingImpl.getInterfaces(intf));
        }
        classes.addAll(ConvertingImpl.getInterfaces(cls.getSuperclass()));
        return classes;
    }

    private void handleDTOField(Object obj, Field field, Set<String> handledFields, Map result, InternalConverter converter) {
        String fn = Util.getDTOKey(field);
        if (fn == null) {
            return;
        }
        if (handledFields.contains(fn)) {
            return;
        }
        try {
            Object fVal = field.get(obj);
            result.put(fn, fVal);
            handledFields.add(fn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleBeanMethod(Object obj, Method md, Set<String> invokedMethods, Map res) {
        String bp = Util.getBeanKey(md);
        if (bp == null) {
            return;
        }
        if (invokedMethods.contains(bp)) {
            return;
        }
        try {
            res.put(bp, md.invoke(obj, new Object[0]));
            invokedMethods.add(bp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleInterfaceMethod(Object obj, Class<?> intf, Method md, Set<String> invokedMethods, Map res) {
        String mn = md.getName();
        if (invokedMethods.contains(mn)) {
            return;
        }
        String propName = Util.getInterfacePropertyName(md, Util.getSingleElementAnnotationKey(intf, obj), obj);
        if (propName == null) {
            return;
        }
        try {
            Object r = Util.getInterfaceProperty(obj, md);
            if (r == null) {
                return;
            }
            res.put(propName, r);
            invokedMethods.add(mn);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<?, ?> mapView(Object obj, Class<?> sourceCls, InternalConverter converter) {
        if (Map.class.isAssignableFrom(sourceCls) || DTOUtil.isDTOType(sourceCls, true) && obj instanceof Map) {
            return (Map)obj;
        }
        if (Dictionary.class.isAssignableFrom(sourceCls)) {
            return MapDelegate.forDictionary((Dictionary)this.object, this, converter);
        }
        if (DTOUtil.isDTOType(sourceCls, true) || this.sourceAsDTO) {
            return this.createMapFromDTO(obj, converter);
        }
        if (this.sourceAsJavaBean) {
            Map m = ConvertingImpl.createMapFromBeanAccessors(obj, sourceCls);
            if (m.size() > 0) {
                return m;
            }
        } else if (this.hasGetProperties(sourceCls)) {
            return this.getPropertiesDelegate(obj, sourceCls, converter);
        }
        return ConvertingImpl.createMapFromInterface(obj, this.sourceClass);
    }

    private boolean hasGetProperties(Class<?> cls) {
        try {
            Method m = cls.getMethod("getProperties", new Class[0]);
            return m != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<?, ?> getPropertiesDelegate(Object obj, Class<?> cls, InternalConverter converter) {
        try {
            Method m = cls.getMethod("getProperties", new Class[0]);
            return converter.convert(m.invoke(obj, new Object[0])).to(Map.class);
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
    }

    private static boolean isCopyRequiredType(Class<?> cls) {
        if (cls.isEnum()) {
            return false;
        }
        return Map.class.isAssignableFrom(cls) || Collection.class.isAssignableFrom(cls) || DTOUtil.isDTOType(cls, true) || cls.isArray();
    }

    private static boolean isWriteableJavaBean(Class<?> cls) {
        boolean hasNoArgCtor = false;
        for (Constructor<?> ctor : cls.getConstructors()) {
            if (ctor.getParameterTypes().length != 0) continue;
            hasNoArgCtor = true;
        }
        if (!hasNoArgCtor) {
            return false;
        }
        return ConvertingImpl.getSetters(cls).size() > 0;
    }

    private static Set<Method> getSetters(Class<?> cls) {
        HashSet<Method> setters = new HashSet<Method>();
        while (!Object.class.equals(cls)) {
            HashSet<Method> methods = new HashSet<Method>();
            methods.addAll(Arrays.asList(cls.getMethods()));
            for (Method md : methods) {
                String name;
                if (md.getParameterTypes().length != 1 || (name = md.getName()).length() < 4 || !name.startsWith("set") || !Character.isUpperCase(name.charAt(3))) continue;
                setters.add(md);
            }
            cls = cls.getSuperclass();
        }
        return setters;
    }

    static {
        HashMap<Class<Deque>, Class<LinkedList>> cim = new HashMap<Class<Deque>, Class<LinkedList>>();
        cim.put(Collection.class, ArrayList.class);
        cim.put(List.class, ArrayList.class);
        cim.put(Set.class, LinkedHashSet.class);
        cim.put(NavigableSet.class, TreeSet.class);
        cim.put(SortedSet.class, TreeSet.class);
        cim.put(Queue.class, LinkedList.class);
        cim.put(Deque.class, LinkedList.class);
        HashMap<Class<SortedMap>, Class<TreeMap>> iim = new HashMap<Class<SortedMap>, Class<TreeMap>>(cim);
        iim.put(Map.class, LinkedHashMap.class);
        iim.put(ConcurrentMap.class, ConcurrentHashMap.class);
        iim.put(ConcurrentNavigableMap.class, ConcurrentSkipListMap.class);
        iim.put(NavigableMap.class, TreeMap.class);
        iim.put(SortedMap.class, TreeMap.class);
        HashSet nmv = new HashSet(cim.keySet());
        nmv.addAll(Arrays.asList(String.class, Class.class, Comparable.class, CharSequence.class, Map.Entry.class));
        ConvertingImpl.addClassIfAvailable("java.lang.constant.Constable", nmv);
        ConvertingImpl.addClassIfAvailable("java.lang.constant.ConstantDesc", nmv);
        INTERFACE_IMPLS = Collections.unmodifiableMap(iim);
        NO_MAP_VIEW_TYPES = Collections.unmodifiableSet(nmv);
    }
}

