/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.dashboards;

import java.security.Principal;
import java.util.Iterator;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * The <code>DashboardService</code> provides methods to get user- and shared Dashboards.
 */
public interface DashboardService {

    /**
     * Returns the Dashboard resources for a certain <code>principal</code>.
     * 
     * @param resolver ResourceResolver used to access resources.
     * @param principal User principal to get the resources for
     * @return a {@link Iterator} over resources representing the users
     *         dashboard's
     * @throws DashboardException if an error occurs while accessing the
     *             resources
     */
    Iterator<Resource> getUserDashboards(ResourceResolver resolver, Principal principal) throws DashboardException;

}
