/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.export.json;

import java.util.Map;

import javax.annotation.Nonnull;

import org.osgi.annotation.versioning.ConsumerType;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Defines the JSON export of a container component.
 *
 * <p>
 * This interface is aimed at being implemented by Sling Model classes corresponding to container components (page, responsive grid, parsys, etc.).
 * </p>
 * <p>
 * <strong>NOTE</strong>: Getter methods' names are all prefixed to avoid name conflicts with methods from the implementation class.
 * </p>
 */
@ConsumerType
public interface ContainerExporter extends ComponentExporter {

    /**
     * <p>
     * Returns the map of all exported child items (resource names from Sling Model classes).
     * </p>
     * <p>
     * <strong>NOTE:</strong> Methods whose JSON serialization would lead to the same JSON property name (":items") <i>will
     * <strong>not</strong> be serialized</i>.
     * </p>
     *
     * @return the map of all exported child items
     * @see #getExportedType()
     */
    @Nonnull
    @JsonProperty(ExporterConstants.PN_ITEMS)
    Map<String, ? extends ComponentExporter> getExportedItems();

    /**
     * <p>
     * Returns the order of items in the map.
     * </p>
     * <p>
     * <strong>NOTE:</strong> This information is required because the JSON specification and most implementations don't provide a
     * stable order of items in JSON objects. Methods whose JSON serialization would lead to the same JSON property name (":order")
     * <i>will <strong>not</strong> be serialized</i>.
     * </p>
     *
     * @return the order of the items in the map; the array can be empty if the item order is not provided by the underlying persistence
     * layer
     */
    @Nonnull
    @JsonProperty(ExporterConstants.PN_ITEMS_ORDER)
    String[] getExportedItemsOrder();

}
