/*
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2019 Adobe
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe and its suppliers, if any. The intellectual
 * and technical concepts contained herein are proprietary to Adobe
 * and its suppliers and are protected by all applicable intellectual
 * property laws, including trade secret and copyright laws.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe.
 */
package com.adobe.cq.inbox.api.preferences.domain.view;

import org.apache.commons.lang3.StringUtils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * The representation of a column in {@link ViewConfiguration}
 */
public final class ViewConfigurationColumn {
    private String title;
    private String name;

    public ViewConfigurationColumn(String title, @Nonnull String name) {
        this.title = title;
        this.name = name;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public @Nonnull String getTitle() {
        return StringUtils.isNotEmpty(title) ? title : name;
    }

    public @Nonnull String getName() {
        return name;
    }
}
