package com.adobe.cq.mcm.campaign;

/**
 * Exception while replicating a newsletter (providing additional information)
 */
public class NewsletterReplicationException extends NewsletterException {

    public static enum Type {

        NO_ACCESS,

        GENERIC

    };

    private final String userID;

    private final String path;

    private final Type type;

    public NewsletterReplicationException(String message, Throwable throwable, Type type,
                                          String userId, String path) {
        super(message, throwable);
        this.type = type;
        this.userID = userId;
        this.path = path;
    }

    public NewsletterReplicationException(String message, Throwable throwable, Type type) {
        this(message, throwable, type, null, null);
    }

    public NewsletterReplicationException(String message, Throwable throwable) {
        this(message, throwable, Type.GENERIC);
    }

    public String getUserID() {
        return userID;
    }

    public String getPath() {
        return path;
    }

    public Type getType() {
        return type;
    }

}
