/*
 * ************************************************************************
 *  *
 *  * ADOBE CONFIDENTIAL
 *  * __________________
 *  *
 *  *  Copyright 2023 Adobe Incorporated
 *  *  All Rights Reserved.
 *  *
 *  * NOTICE:  All information contained herein is, and remains
 *  * the property of Adobe Incorporated and its suppliers,
 *  * if any.  The intellectual and technical concepts contained
 *  * herein are proprietary to Adobe Incorporated and its
 *  * suppliers and are protected by trade secret or copyright law.
 *  * Dissemination of this information or reproduction of this material
 *  * is strictly forbidden unless prior written permission is obtained
 *  * from Adobe Incorporated.
 *  *************************************************************************
 */

package com.adobe.cq.wcm.launches.cf;

import com.adobe.cq.dam.cfm.ContentFragment;
import com.adobe.cq.launches.api.Launch;
import org.osgi.annotation.versioning.ProviderType;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import java.util.Calendar;

/**
 * Interface to retrieve specific data related to a Content Fragment Launch.
 */
@ProviderType
public interface ContentFragmentLaunch extends Launch {

    /**
     * Gets last rebase date of a Content Fragment residing inside a launch.
     * @param contentFragment Content Fragment
     * @param compare Launch containing the Content Fragment
     * @return date of last rebase
     */
    Calendar getLastRebased(@Nonnull ContentFragment contentFragment, @Nonnull Launch compare);

    /**
     * Sets last rebase date of a Content Fragment residing inside a launch.
     * @param contentFragment Content Fragment
     * @param lastRebased Last rebase date
     * @param compare Launch containing the Content Fragment
     */
    void setLastRebased(@Nonnull ContentFragment contentFragment, @Nonnull Calendar lastRebased, @Nonnull Launch compare);

    /**
     * Sets the root resource path of a Launch.
     * @param rootResourcePath Root resource path
     */
    void setRootResource(@Nonnull String rootResourcePath);

    /**
     * The id identifies the launch.
     *
     * @return the id of the launch or null if the launch does not have jcr:uuid.
     */
    @CheckForNull
    String getId();
}
