/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2017 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.wcm.style;

import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.osgi.annotation.versioning.ProviderType;

/**
 * A {@code ComponentStyleInfo} provides methods for retrieving information about the styles defined on a page
 * authoring component (e.g. a title component).
 *
 * @since com.adobe.cq.wcm.style 1.0.0
 */
@ProviderType
public interface ComponentStyleInfo {

    /**
     * Retrieves the style information defined in the content policy of the component.
     *
     * @return the style information if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    ContentPolicyStyleInfo getContentPolicyStyleInfo();

    /**
     * Retrieves the styles that are applied to the component.
     *
     * @return the {@code StyleInfo}s that are applied to the component, an empty list otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nonnull
    List<StyleInfo> getAppliedStyles();

    /**
     * Retrieves the CSS classes that are applied to the component.
     *
     * @return the CSS classes if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getAppliedCssClasses();

    /**
     * Retrieves the HTML element that is applied to the component.
     *
     * @return the HTML element if defined, {@code null} otherwise
     * @since com.adobe.cq.wcm.style 1.0.0
     */
    @Nullable
    String getAppliedHtmlElement();

}