/**
 * File: Permission.java
*
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2004-2007 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
 */
package com.adobe.fontengine.font;

/**
 * Describes the usage rights associated with a font.
 */
final public class Permission {
    private Permission () { 
      // this class provides an enum
    }
    
    /** Embedding permission: cannot embed the font */
    public static final Permission RESTRICTED = new Permission ();
    
    /** Embedding permission: can embed for preview and print */
    public static final Permission PREVIEW_AND_PRINT = new Permission ();
    
    /** Embedding permission: can embed for editing */
    public static final Permission EDITABLE = new Permission ();
    
    /** Embedding permission: can embed for installation */
    public static final Permission INSTALLABLE = new Permission ();
    
    /** Embedding permission: the value in the font is not
     * a legal one. This value is never returned from AFE's public APIs.
     * It is always resolved to one of the above based on the context. */
    public static final Permission ILLEGAL_VALUE = new Permission ();
  }