/**
 * 
 */
package com.adobe.fontengine.font.opentype;

import java.util.Map;

import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.Subset;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.fontengine.font.opentype.LookupTableHarvester.CoverageLookupHarvester;

class ChainingFormat1Harvester implements CoverageLookupHarvester  {
	 
	private final LookupTableHarvester harvester;
	private Map lookups;
	private final boolean continueIterating;
	  
	  ChainingFormat1Harvester(LookupTableHarvester harvester, Map lookups, boolean continueIteratingWhenLookupApplies) {
		  this.harvester = harvester;
		this.lookups = lookups;
		  this.continueIterating = continueIteratingWhenLookupApplies;
	  }
	  
	  public boolean keepGoing() {
		return continueIterating;
	}
	  
	  private boolean glyphsApply(int numGlyphs, int chainSubruleOffset, int delta, Subset gids) throws InvalidFontException, UnsupportedFontException
	  {
		  int j;
		  for (j = 0; j < numGlyphs; j++)
		  {
			  int gid = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2 + 2*j);
			  if (gids.getExistingSubsetGid(gid) == -1)
				  return false;
		  }
		  
		  return true;
		  
	  }
	  
	  public boolean lookupApplies(int coverageGlyph, int stOffset, int coverageIndex, Subset gids) throws InvalidFontException, UnsupportedFontException {
		  
		  int chainSubruleSetOffset = harvester.lookupTable.data.getOffset (stOffset, 6 + 2*coverageIndex);
		  int chainSubruleCount = harvester.lookupTable.data.getuint16(chainSubruleSetOffset);
		  boolean applies = false;

		  for (int i = 0; i < chainSubruleCount; i++)
		  {
			  int chainSubruleOffset = harvester.lookupTable.data.getOffset(chainSubruleSetOffset, 2 + 2*i);
			  int backtrackCount = harvester.lookupTable.data.getuint16(chainSubruleOffset);
			  if (!glyphsApply(backtrackCount, chainSubruleOffset, 0, gids))
			  {
				  continue;
			  }
			  
			  int delta = 2 + 2*backtrackCount;
			  int glyphCount = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta)-1;
			  if (!glyphsApply(glyphCount, chainSubruleOffset, delta, gids))
			  {
				  continue; 
			  }
			  
			  delta += 2 + 2*glyphCount;
			  int lookaheadCount = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta);
			  if (!glyphsApply(lookaheadCount, chainSubruleOffset, delta, gids))
			  {
				  continue;
			  }
		  
		  
			  delta += 2 + 2*lookaheadCount;
			  int lookupCount = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta);
			  for (int j = 0; j < lookupCount; j++)
			  {
				  int lookupIndex = harvester.lookupTable.data.getuint16(chainSubruleOffset + delta + 2 + 4*j + 2);
				  this.harvester.harvest(gids, lookupIndex, lookups);
			  }
			  applies = true;

		  }
		  
		  return applies;
		  
	  }
  }