package com.adobe.fontengine.font.opentype;

class IntGrowableArray {
		
		private final static int BUFFER_SIZE = 50;
		private final static int BUFFER_INCR = 50;

		private int[] buffer;
		private int length;

		IntGrowableArray() {
			buffer = new int[BUFFER_SIZE];
			length = 0;
		}
		
		private void grow(int index)
		{
			if (index >= buffer.length) {
				//grow buffer
				int newBufferSize = buffer.length;
				while (index >= newBufferSize) {
					newBufferSize += BUFFER_INCR;
				}
				//copy from current buffer to new buffer
				int newBuffer[] = new int[newBufferSize];
				System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
				buffer = newBuffer;
			}
		}
		
		void set(int data) {
			set(data, length);
		}
		
		void set(int data, int index) {
			grow(index);
			buffer[index] = data;
			if (length <= index) 
				length = index+1;
		}
	
		int get(int index) {
			if (index < length)
				return buffer[index];
			else
				return 0;
		}
		
		int[] getBuffer() {
			return buffer;
		}
		
		int getLength() {
			return length;
		}
}
