/*
 * File: OTSelectorOnElementAttribute.java
 * 
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2004-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */

package com.adobe.fontengine.font.opentype;

import com.adobe.fontengine.inlineformatting.AttributedRun;
import com.adobe.fontengine.inlineformatting.ElementAttribute;

final public class OTSelectorOnElementAttribute extends OTSelector {
  private final ElementAttribute att;
  private final Object value;
  private final boolean attEquals;
  
  public OTSelectorOnElementAttribute (ElementAttribute att, Object value, boolean attEquals) {
    this.att = att;
    this.value = value;
    this.attEquals = attEquals;
  }
  
  /* @see com.adobe.fontengine.font.opentype.OTSelector#isApplied(com.adobe.fontengine.inlineformatting.AttributedRun, int)
   */
  public boolean isApplied (AttributedRun run, int position) {
    return (run.getElementStyle (position, att) == value) == attEquals;
  }
}
