/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.security.user.util;

import java.util.Iterator;

public class SkipIterator<T> implements Iterator<T> {
    private final Iterator<T> iterator;
    private int pos;

    public static <T> SkipIterator<T> create(Iterator<T> iterator) {
        return new SkipIterator<T>(iterator);
    }

    public SkipIterator(Iterator<T> iterator) {
        this.iterator = iterator;
    }

    /**
     * Attempts to skip a number of elements
     * 
     * @param skipNum
     *            number of elements to skip
     * @return long value with the number of elements that were actually skipped
     */
    public long skip(long skipNum) {
        long c = 0;
        for(; c < skipNum && iterator.hasNext(); c++, pos++) {
            iterator.next();
        }
        
        return c;
    }

    public long getPosition() {
        return pos;
    }

    public boolean hasNext() {
        return iterator.hasNext();
    }

    public T next() {
        pos++;
        return iterator.next();
    }

    public void remove() {
        iterator.remove();
    }
}
