/*************************************************************************
* ADOBE CONFIDENTIAL
* ___________________
*
* Copyright 2014 Adobe
* All Rights Reserved.
*
* NOTICE: All information contained herein is, and remains
* the property of Adobe and its suppliers, if any. The intellectual
* and technical concepts contained herein are proprietary to Adobe
* and its suppliers and are protected by all applicable intellectual
* property laws, including trade secret and copyright laws.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
* from Adobe.
**************************************************************************/
package com.adobe.granite.ui.components.rendercondition;

import javax.annotation.Nonnull;

/**
 * A condition that takes a simple boolean for the decision.
 */
public final class SimpleRenderCondition implements RenderCondition {
    /**
     * The condition that always returns {@code true}.
     */
    @Nonnull
    public static final RenderCondition TRUE = new SimpleRenderCondition(true);

    /**
     * The condition that always returns {@code false}.
     */
    @Nonnull
    public static final RenderCondition FALSE = new SimpleRenderCondition(false);

    private boolean decision;

    /**
     * Instantiates based on the given boolean decision.
     *
     * @param decision
     *            the decision
     */
    public SimpleRenderCondition(boolean decision) {
        this.decision = decision;
    }

    @Override
    public boolean check() {
        return decision;
    }
}
