/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.core.event;

import java.io.Serializable;
import java.util.Map;

/**
 * A helper class to define and create external process polling events, identified using the topic {@link #EVENT_TOPIC}
 */
public class ExternalProcessPollingEvent implements Serializable {

    private static final long serialVersionUID = -2349473421221460240L;

    /**
     * The job topic for adding an entry to the audit log.
     */
    public static final String EVENT_TOPIC = "com/adobe/granite/workflow/external/polling/event";

    public static final String PROPERTY_POLLING_TIMEOUT = "com.adobe.granite.workflow.event.polling.timeout";
    public static final String PROPERTY_POLLING_ADVANCE_ON_TIMEOUT = "com.adobe.granite.workflow.event.polling.advanceOnTimeout";
    public static final String PROPERTY_POLLING_START = "com.adobe.granite.workflow.event.polling.start";
    public static final String PROPERTY_POLLING_EVENT = "com.adobe.granite.workflow.event.polling";
    public static final String PROPERTY_POLLING_PROCESS_ID = "com.adobe.granite.workflow.event.polling.process.id";

    private Map<String, Serializable> workItemMap;

    /**
     * even though this is not needed it must be left for backwards compatibility, since we may have serialized instances of this class in the system.
     */
    private Serializable externalProcessId;

    /**
     * Creates a new WorkflowJob.
     * @param workItemMap the work item map
     * @param externalProcessId the external process id
     */
    public ExternalProcessPollingEvent(Map<String, Serializable> workItemMap, Serializable externalProcessId) {
        if (workItemMap == null) {
            throw new IllegalArgumentException("work item must not be null.");
        }
        if (externalProcessId == null) {
            throw new IllegalArgumentException("externalProcessId must not be null.");
        }
        this.workItemMap = workItemMap;
        this.externalProcessId = externalProcessId;
    }

    public Map<String, Serializable> getWorkItemMap() {
        return workItemMap;
    }
}
