/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.job;

import com.adobe.granite.workflow.exec.WorkItem;

/**
 * The <code>AbsoluteTimeoutHandler</code> is kind of a marker interface for
 * absolute timeouts (timeout is happening at a specific date)
 */
public interface AbsoluteTimeoutHandler {
    /**
     * metadata name for the absolute timeout time
     */
    static final String ABS_TIME = "absoluteTime";

    /**
     * Returns the timeout time in ms.
     *
     * @param item workitem
     *
     * @return timeout time/date in ms in case the time/date is set
     * otherwise <code>-1</code>
     */
    long getTimeoutDate(WorkItem item);
}
