/*
 * File: CosObjectID.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.cos;

/**
 * An indirect object number and generation ID object.
 */
public final class CosObjectID {
	private int mObjNum;		// indirect object number
	private int mObjGen;		// indirect object generation

	/**
	 * Constructor to generate an ID for a cosobject with passed object number and generation number.
	 * @exclude
	 */
	public CosObjectID(int objNum, int objGen)
	{
		mObjNum = objNum;
		mObjGen = objGen;
	}

	/**
	 * Returns object number.
	 * @exclude
	 */
	public int getObjNum()
	{
		return mObjNum;
	}

	/**
	 * Returns object generation number.
	 * @exclude
	 */
	public int getObjGen()
	{
		return mObjGen;
	}

	
	@Override
	public int hashCode()
	{
		return (mObjGen << 24) | (mObjNum & 0xFFFFFF);
	}

	
	@Override
	public boolean equals (Object obj)
	{
		if(obj instanceof CosObjectID) 
			if (mObjNum == ((CosObjectID)obj).mObjNum && mObjGen == ((CosObjectID)obj).mObjGen)
				return true;
		return false;
	}
}
