/* ****************************************************************************
*
*	File: PermissionProvider.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.permissionprovider;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;

/**
 * This interface must be implemented by each permission provider. 
 * This class specifies the available permission providers. 
 *         
 * @author speri
 */
public interface  PermissionProvider 
{
   /**
    * Permission provider for the security (encryption) handlers. 
    * The security handlers include Standard, PubSec, APS, eBook.
    * @see com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler#getPermissionProvider() 
    */
	public static final String  SECURITY = "Security";

	/**
	 * Permission provider for DocMDP author signatures.
	 * An author may specify what changes are allowed to 
	 * a document before the signature becomes invalid.
	 */
	public static final String  DOC_MDP = "DocMDP";

	/**
	 * Permission provider for usage rights.
	 * It enables features in Acrobar Reader.
	 */
	public static final String  UR = "UR";

	/**
	 * Permission provider for user permissions.
	 * This allows lightweight setting and clearing of document permissions. 
	 * These permissions are not protected by signatures or encryption. 
	 * Therefore, they can be set and cleared by any user.
	 */
	public static final String  UP = "UP";

	/**
	 * Permission provider for XFA usage. This applies to static and dynamic XFA.
	 */
	public static final String  XFA = "XFA";
	
	/**	
	 * Every permission provider must implement this method 
	 * to query a particular object-operation combination.
	 * Subsequent calls to this method will refer to the document specified by  
	 * the <code>doc</code> parameter.
	 * @param objOpr a valid combination of object/operations 
	 * available in Acrobat 7.0 Professional.  
	 * @return	boolean <code>true</code> if the specified operation is permitted; <code>false</code> otherwise. 
	 * @throws PDFUnableToCompleteOperationException if the specified operation cannot be completed.
  	 */
	public boolean isPermitted(ObjectOperations objOpr ) throws PDFUnableToCompleteOperationException;
}
