/* ****************************************************************************
*
*	File: Stack
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/
package com.adobe.internal.util;


/**
 * @author speri
 *
 * Generic interface for Stack implementation.
 * 
 */
public interface Stack<T>
{
	/**
	 * Adds an item to the top of the stack.
	 * @param x the item to add.
	 * @return the item added.
	 */
	T push(T x);

	/**
	 * Removes and returns item from the top of the stack.
	 * @return the former top item.
	 * @throws java.util.EmptyStackException if stack is empty.
	 */
	T pop();

	/**
	 * Returns item from the top of the stack.
	 * @return the top item.
	 * @throws java.util.EmptyStackException if stack is empty.
	 */
	T peek();

	/**
	 * Tests if stack is empty.
	 * @return true if the stack is empty; false otherwise.
	 */
	boolean empty();

	/**
	 * Returns the size of the stack.
	 * @return the size of the stack.
	 */
	int size();

	void clear();
}