/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren;

import java.util.Arrays;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A {@link Link} represents a navigational transition.
 */
public final class Link {

    private String[] rel;

    private String href;

    private String title;

    private String type;

    /**
     * Constructs a new Link.
     * 
     * @param rel
     * @param href
     * @throws IllegalArgumentException if either {@code rel} or {@code href}
     *             are {@code null} or empty.
     */
    public Link(String[] rel, String href) throws IllegalArgumentException {
        if (rel == null || rel.length == 0 || href == null || href.isEmpty()) {
            throw new IllegalArgumentException("rel and href can not be null or empty");
        }
        this.rel = rel;
        this.href = href;
    }

    /**
     * Returns the rel attribute.
     * 
     * @return
     */
    public String[] getRel() {
        return rel;
    }

    /**
     * Sets the rel attribute.
     * 
     * @param rel
     */
    public void setRel(String[] rel) {
        this.rel = rel;
    }

    /**
     * Returns the href attribute.
     * 
     * @return
     */
    public String getHref() {
        return href;
    }

    /**
     * Sets the href attribute.
     * 
     * @param href
     */
    public void setHref(String href) {
        if (href == null || href.isEmpty()) {
            throw new IllegalArgumentException("href can not be null or empty.");
        }
        this.href = href;
    }

    /**
     * Returns the title attribute.
     * 
     * @return
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title attribute.
     * 
     * @param title
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Returns the type attribute.
     * 
     * @return
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the type attribute.
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        try {
            JSONObject link = new JSONObject();
            link.put("rel", rel);
            link.put("href", href);
            if (title != null) {
                link.put("title", title);
            }
            if (type != null) {
                link.put("type", type);
            }
            return link.toString();
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((href == null) ? 0 : href.hashCode());
        result = prime * result + Arrays.hashCode(rel);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        Link other = (Link) obj;
        if (href == null) {
            if (other.href != null) return false;
        } else if (!href.equals(other.href)) return false;
        if (!Arrays.equals(rel, other.rel)) return false;
        return true;
    }

}
