/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class TagnameFilter extends NodeListFilter {

	private int meTag;

	/**
	 * Default constructor for TagnameFilter.
	 * When this constructor is used, the tag should be set before using this filter.
	 * @see #setTagname(int)
	 */
	public TagnameFilter() {
	}

	/**
	 * Constructor for TagnameFilter.
	 * 
	 * @param eTag
	 *            Note that the tag provided must be one of the tags
	 *            contained in the XFA namespace. e.g.
	 *            <code>XFA.FIELDTAG</code>
	 */
	public TagnameFilter(int eTag) {
		setTagname(eTag);
	}

	/**
	 * The accept method defines a set of criteria that each node must pass if
	 * it is to be accepted by this filter.
	 */
	public boolean accept(Node node) {
		return node.getClassTag() == meTag;
	}

	/**
	 * Set the tag to look for when filtering nodes.
	 * 
	 * @param eTag
	 *            Note that the tag provided must be one of the tags
	 *            contained in the XFA namespace. e.g.
	 *            <code>XFA.FIELDTAG</code>
	 */
	public void setTagname(int eTag) {
		meTag = eTag;
	}
}