/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2009 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/**
 * Implements the W3C DOM Node interface.  This class does not wrap any
 * XFA object instance.  It provides only base-level services and
 * default method implementations.
 * @exclude from published api.
 */
abstract class NodeImpl implements Node {
	static final String COMMENT_NODE_NAME = "#comment";
	static final String DOCUMENT_NODE_NAME = "#document";
	static final String TEXT_NODE_NAME = "#text";

	static final boolean DO_DEBUG = false;

	private final ParentNode mParent;
	private NodeImpl mPrev;
	private NodeImpl mNext;
	private final DocumentImpl mDocument;

//	@FindBugsSuppress(code="UuF")
//	private StringBuilder mDebugBuilder;
//	@FindBugsSuppress(code="UuF,UwF")
//	String mDebugPrefix;
	final int mNodeID;
	static int gNodeIDCounter = 0;

	NodeImpl (ParentNode parent) {
		mParent = parent;
		
		DocumentImpl document = null;
		if (parent != null) {
			if (parent instanceof DocumentImpl) {
				document = (DocumentImpl) parent;
			} else {
				document = parent.getDocument();
			}
		}
		mDocument = document;
		mNodeID = ++gNodeIDCounter;
	}

	public Node appendChild(Node newChild) throws DOMException {
		throw new DOMException (DOMException.NO_MODIFICATION_ALLOWED_ERR, "");
	}

	public Node cloneNode(boolean deep) {
		throw new DOMException (DOMException.NOT_SUPPORTED_ERR, "");
	}

	public short compareDocumentPosition(Node other) throws DOMException {
		return DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC;
	}

	public NamedNodeMap getAttributes() {
		return null;
	}

	public String getBaseURI() {
		return null;
	}

	public NodeList getChildNodes() {
		return null;
	}

	public Object getFeature(String feature, String version) {
		return null;
	}

	public Node getFirstChild() {
		return null;
	}

	public Node getLastChild() {
		return null;
	}

	public String getLocalName() {
		return null;
	}

	public String getNamespaceURI() {
		return null;
	}

	public Node getNextSibling() {
		return null;
	}

	public String getNodeValue() throws DOMException {
		return null;
	}

	public Document getOwnerDocument() {
//		debugReturn ("getOwnerDocument", mDocument);
		return mDocument;
	}

	public Node getParentNode() {
//		debugReturn ("getParentNode", mParent);
		return mParent;
	}

	public String getPrefix() {
		return null;
	}

	public Node getPreviousSibling() {
		return null;
	}

	public String getTextContent() throws DOMException {
		return null;
	}

	public Object getUserData(String key) {
		return null;
	}

	public boolean hasAttributes() {
		return false;
	}

	public boolean hasChildNodes() {
		return false;
	}

	public Node insertBefore(Node newChild, Node refChild) throws DOMException {
		throw new DOMException (DOMException.HIERARCHY_REQUEST_ERR, "");
	}

	public boolean isDefaultNamespace(String namespaceURI) {
		return (mParent == null) ? false : mParent.isDefaultNamespace (namespaceURI);
	}

	public boolean isSupported(String feature, String version) {
		return false;
	}

	public String lookupNamespaceURI(String prefix) {
		return (mParent == null) ? null : mParent.lookupNamespaceURI (prefix);
	}

	public String lookupPrefix(String namespaceURI) {
		return (mParent == null) ? null : mParent.lookupPrefix (namespaceURI);
	}

	public void normalize() {
	}

	public Node removeChild(Node oldCcild) throws DOMException {
		return null;
	}

	public Node replaceChild(Node oldChild, Node newChild) throws DOMException {
		throw new DOMException (DOMException.HIERARCHY_REQUEST_ERR, "");
	}

	public void setNodeValue(String newValue) throws DOMException {
	}

	public void setPrefix(String prefix) throws DOMException {
	}

	public void setTextContent(String textContent) throws DOMException {
	}

	public Object setUserData(String key, Object data, UserDataHandler handler) {
		return null;
	}

	final DocumentImpl getDocument () {
		return ((mDocument == null) && (this instanceof DocumentImpl)) ? ((DocumentImpl) this) : mDocument;
	}

	final ParentNode getParent() {
		return mParent;
	}

	final NodeImpl getNext() {
		return mNext;
	}

	final void setNext (NodeImpl newNext) {
		mNext = newNext;
	}

	final NodeImpl getPrev() {
		return mPrev;
	}

	final void setPrev (NodeImpl newPrev) {
		mPrev = newPrev;
	}

//	final void debugInit (String type) {
//		if (DO_DEBUG) {
//			StringBuilder initBuilder = debugInitCommon (type);
//			mDebugPrefix = initBuilder.toString();
//		}
//	}
//
//	final void debugInit (String type, String name) {
//		if (DO_DEBUG) {
//			StringBuilder initBuilder = debugInitCommon (type);
//			initBuilder.append (' ');
//			initBuilder.append (name);
//			mDebugPrefix = initBuilder.toString();
//		}
//	}
//
//	final void debug (String text) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugEnd();
//		}
//	}
//
//	final void debugMethod1 (String text, String string1) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugAdd (" (");
//			debugAddString (string1);
//			debugAdd (")");
//			debugEnd();
//		}
//	}
//
//	final void debugMethod2 (String text, String string1, String string2) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugAdd (" (");
//			debugAddString (string1);
//			debugAdd (", ");
//			debugAddString (string2);
//			debugAdd (")");
//			debugEnd();
//		}
//	}
//
//	final void debugNewChild (NodeImpl parent) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd ("created under ");
//			debugAdd ((parent == null) ? "(null)" : parent.mDebugPrefix);
//			debugEnd();
//		}
//	}
//
//	final void debugReturn (String text, String result) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugAdd ("(): ");
//			debugAddString (result);
//			debugEnd();
//		}
//	}
//
//	final void debugReturn (String text, NodeImpl result) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugAdd ("(): ");
//			debugAdd ((result == null) ? "(null)" : result.mDebugPrefix);
//			debugEnd();
//		}
//	}
//
//	final void debugReturn1 (String text, String string1, String result) {
//		if (DO_DEBUG) {
//			debugStart();
//			debugAdd (text);
//			debugAdd (" (");
//			debugAddString (string1);
//			debugAdd ("): ");
//			debugAddString (result);
//			debugEnd();
//		}
//	}
//
//	final void debugStart () {
//		if (DO_DEBUG) {
//			if (mDebugBuilder == null) {
//				mDebugBuilder = new StringBuilder (mDebugPrefix);
//			} else {
//				mDebugBuilder.replace (0, mDebugBuilder.length(), mDebugPrefix);
//			}
//			mDebugBuilder.append (' ');
//		}
//	}
//
//	final void debugAdd (String text) {
//		if (DO_DEBUG) {
//			mDebugBuilder.append (text);
//		}
//	}
//
//	final void debugAddString (String string) {
//		if (DO_DEBUG) {
//			if (string == null) {
//				mDebugBuilder.append ("null");
//			} else {
//				mDebugBuilder.append ('"');
//				mDebugBuilder.append (string);
//				mDebugBuilder.append ('"');
//			}
//		}
//	}
//
//	final void debugEnd () {
//		if (DO_DEBUG) {
//			System.out.println (mDebugBuilder.toString());
//		}
//	}
//
//	private final StringBuilder debugInitCommon (String type) {
//		StringBuilder builder = new StringBuilder (type);
//		builder.append (' ');
//		builder.append (Integer.toString (mNodeID));
//		return builder;
//	}
}
