/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.form;


import com.adobe.xfa.template.containers.SubformSet;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.Node;
import com.adobe.xfa.XFA;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumAttr;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.DependencyTracker;

/**
 * @exclude from public api.
 */
public class FormSubformSet extends SubformSet {
	
	private FormInstanceManager mInstanceManager;
	private boolean mbIsLayoutNode;	// is a leader or trailer subform
	
	
	public FormSubformSet(Element parent, Node prevSibling) {
		super(parent, prevSibling);
	}

//	//	~XFAFormSubformSetImpl()
//	void dispose() {	
//		// safety first: remove this subform from the manager
//		// note the manager should be freed prior to the destruction of any instance
//		if (moInstanceManager != null)
//			moInstanceManager.cleanup(this);
//	}


	int	getRelation() {	
		int relation = EnumAttr.RELATION_ORDERED;
		if (hasProto()) {
			ProtoableNode proto = getProto();
			// check for attribute 'relation'
			if (proto.isPropertySpecified(XFA.RELATIONTAG, true, 0)) {
				// 'relation' is specified, get the value
				relation = ((EnumValue)proto.getAttribute(XFA.RELATIONTAG)).getInt();
			}
		}
	
		return relation;
	}

	boolean	isValidSubformChild(String sName) {
		if (StringUtils.isEmpty(sName))
			return false;
	
		String aName = sName.intern();
		
		if (hasProto()) {
			ProtoableNode proto = getProto();
	
			for (Node child = proto.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) { 
				if (child.isSameClass(XFA.SUBFORMTAG) &&
					(child.getName() == aName)) {
					return true;
				}
			}
		}
	
		return false;
	}
	
	FormSubform	getSubformChild(String sName) {
		if (StringUtils.isEmpty(sName))
			return null;
	
		String aName = sName.intern();
	
		for (Node child = getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
			if (child instanceof FormSubform) {
				FormSubform formSubform = (FormSubform)child;
				if (formSubform.getName() == aName)
					return formSubform;
			}
		}
	
		return null;
	}
	
	/**
	 * Check if this subform is a subform generated by layout (eg. a leader or trailer)
	 */
	boolean isLayoutNode() {
		return mbIsLayoutNode;
	}
	
	/**
	 * Sets the indicator that this subform is generated by layout (eg. a leader or trailer)
	 */
	void setLayoutNode() {
		mbIsLayoutNode = true;
	}

	//--------------------------------------------------
	// Overridden methods of Node
	//--------------------------------------------------
	
	/**
	 * @see Node#isSpecified(int, boolean, int)
	 * @exclude from public api.
	 */
	public boolean isSpecified(int eTag,
							   boolean bCheckProtos,
							   int nOccurrence) {
		if (eTag == XFA.OCCURTAG) {	
			FormInstanceManager manager = getInstanceManager();
			if (manager != null)
				return manager.isSpecified(eTag, bCheckProtos, nOccurrence);
		}
		
		return super.isSpecified(eTag, bCheckProtos, nOccurrence);
	}
	
	/**
	 * @exclude from public api.
	 */
	public Element getElement(int eTag,
					boolean bPeek /* = FALSE */,
					int nOccurrence /* = 0 */,
					boolean bReturnDefault /* = FALSE */,
					boolean bValidate /* = FALSE */) {
		if (eTag == XFA.OCCURTAG) {	
			FormInstanceManager manager = getInstanceManager();
			if (manager != null)
				return manager.getElement(eTag,bPeek,nOccurrence,bReturnDefault,bValidate);
		}

		return super.getElement(eTag,bPeek,nOccurrence,bReturnDefault,bValidate);
	}
	
	
	/**
	 * @exclude from public api.
	 */
	public Node setElement(Node child,
					int eTag /* = XFA.SCHEMA_DEFAULT */, 
					int nOccurrence /* = 0 */ ) {
		if (eTag == XFA.OCCURTAG) {	
			FormInstanceManager manager = getInstanceManager();
			if (manager != null)
				manager.setElement(child, eTag, nOccurrence);
		}

		return super.setElement(child, eTag, nOccurrence);
	}
	
	//--------------------------------------------------
	// Overridden methods of SubformSet
	//--------------------------------------------------
	
	/**
     * Returns the FormInstanceManager for this subformset
     * @return a FormInstanceManager
     */
	public FormInstanceManager getInstanceManager() {
		return mInstanceManager;
	}
	
	void setInstanceManager(FormInstanceManager instanceManager) {
		mInstanceManager = instanceManager;
	}
	
	/**
	 * @exclude from public api.
	 */
	protected int getInstanceIndex(DependencyTracker dependencyTrack /* = NULL */) {
		if (mInstanceManager != null) {
			if (dependencyTrack != null)
				dependencyTrack.addDependency(mInstanceManager);
			return mInstanceManager.findIndex(this);
		}
		return 0;
	}
	
	/**
	 * @exclude from public api.
	 */
	public void setInstanceIndex(int nMoveTo) {
		// Form method only
		if (mInstanceManager != null) {
			int nIndex = mInstanceManager.findIndex(this);
			mInstanceManager.moveInstance(nIndex, nMoveTo, true);
		}
	}
}
