/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.template.containers;


import com.adobe.xfa.Arg;
import com.adobe.xfa.ArrayNodeList;
import com.adobe.xfa.DependencyTracker;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptFuncObj;
import com.adobe.xfa.ScriptTable;
import com.adobe.xfa.XFA;


/**
 * This class contains all the script functionality associated with the
 * Subform class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class SubformScript extends ContainerScript {

	static final ScriptTable moScriptTable = new ScriptTable(
		ContainerScript.moScriptTable,
		"subform",
		new ScriptPropObj[] {
			new ScriptPropObj(SubformScript.class, "message", "getMessage", "setMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_DEPRECATED/*, XFA_IS_SUBFORM_MESSAGE_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "validationMessage", "getMessage", "setMessage", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_SUBFORM_MESSAGE_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "instanceManager", "getInstanceManager", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_INSTANCEMANAGER_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "fillColor", "getBackColor", "setBackColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_SUBFORM_BACKCOLOR_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "borderColor", "getBorderColor", "setBorderColor", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_SUBFORM_BORDERCOLOR_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "borderWidth", "getBorderWidth", "setBorderWidth", Arg.STRING, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_SUBFORM_BORDERWIDTH_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "dataNode", "dataNode", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_DATANODE_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "instanceIndex", "getInstanceIndex", "setInstanceIndex", Arg.INTEGER, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_FORM_INSTANCEINDEX_DESC, 0*/, 0),
			new ScriptPropObj(SubformScript.class, "errorText", "getErrorText", null, Arg.STRING, Schema.XFAVERSION_30, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_SUBFORM_ERRORTEXT_DESC, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(SubformScript.class, "execCalculate", "execCalculate", Arg.EMPTY,
				new int [] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECCALCULATE_DESC, 0, null*/, 0),
			new ScriptFuncObj(SubformScript.class, "execValidate", "execValidate", Arg.BOOL,
				new int [] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECVALIDATE_DESC, XFA_IS_FORM_EXECVALIDATE_RET, null*/, 0),
			new ScriptFuncObj(SubformScript.class, "execInitialize", "execInitialize", Arg.EMPTY,
				new int [] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECINITIALIZE_DESC, 0, null*/, 0),
			new ScriptFuncObj(SubformScript.class, "execEvent", "execEvent", Arg.EMPTY,
				new int [] { Arg.STRING/*, XFA_IS_FORM_EXECEVENT_PARAM1*/ }, 1, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_FORM_EXECEVENT_DESC, 0, null*/, 0),
			new ScriptFuncObj(SubformScript.class, "getInvalidObjects", "getInvalidObjects", Arg.OBJECT, 
				new int[] { }, 0, Schema.XFAVERSION_30, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_SUBFORM_GETINVALIDOBJECTS_DESC,0, NULL*/, 0)
		}
	);

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	// message still works but should use "validationMessage" 
	// (we don't want to document "message" that is why it has a XFAAVAILABILITY_DEPRECATED)

	public static void getMessage(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Subform) pObj).getMessage());
	}

	public static void setMessage(Obj pObj, Arg propertyValue) {
		((Subform) pObj).setMessage(propertyValue.getString());
	}

	public static void getBackColor(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Subform) pObj).getBackColor());
	}

	public static void setBackColor(Obj pObj, Arg propertyValue) {
		((Subform) pObj).setBackColor(propertyValue.getString());
	}

	public static void getBorderColor(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Subform) pObj).getBorderColor());
	}
	public static void setBorderColor(Obj pObj, Arg propertyValue) {
		((Subform) pObj).setBorderColor(propertyValue.getString());
	}

	public static void getBorderWidth(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Subform) pObj).getBorderWidth());
	}

	public static void setBorderWidth(Obj pObj, Arg propertyValue) {
		((Subform) pObj).setBorderWidth(propertyValue.getString());
	}

	public static void getInstanceManager(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Subform) pObj).getInstanceManager());
	}

	public static void dataNode(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Subform) pObj).getDataNode());
	}

	public static void getInstanceIndex (Obj pObj, Arg oRetVal, DependencyTracker pDepTrack) {
		oRetVal.setInteger(Integer.valueOf(((Subform) pObj).getInstanceIndex(pDepTrack)));
	}

	public static void setInstanceIndex(Obj pObj, Arg propertyValue) {
		if (propertyValue.getArgType() != Arg.NULL)
			((Subform) pObj).setInstanceIndex(propertyValue.getInteger().intValue());
	}
	
	public static void getErrorText(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Subform) pObj).getErrorText());
	}

	public static void execCalculate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Subform) pObj).execEvent(XFA.CALCULATE);
	}

	public static void execValidate(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setBool(Boolean.valueOf(((Subform) pObj).execValidate()));
	}

	public static void execInitialize(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Subform) pObj).execEvent("initialize");
	}

	public static void execEvent(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Subform) pObj).execEvent(pArgs[0].getString());
	}
	
	public static void getInvalidObjects(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		ArrayNodeList invalidObjects = new ArrayNodeList();
		((Subform) pObj).getInvalidObjects(invalidObjects);
		oRetVal.setObject(invalidObjects);
	}
}
