// =================================================================================================
// ADOBE SYSTEMS INCORPORATED
// Copyright 2011 Adobe Systems Incorporated
// All Rights Reserved
//
// NOTICE:  Adobe permits you to use, modify, and distribute this file in accordance with the terms
// of the Adobe license agreement accompanying it.
// =================================================================================================

package com.adobe.xmp.schema.model.rules;

import java.util.ArrayList;
import java.util.List;

import com.adobe.xmp.schema.model.SchemaVisitor;
import com.adobe.xmp.schema.model.TypeRule;
import com.adobe.xmp.schema.model.XMPSchemaException;

/**
 * The logical rule describes a conjunction (AND), disjunction (OR) or negation (NOT)
 * of the child rules.
 * <em>Note:</em> The operator NOT can only take one argument.
 * 
 * @author Stefan Makswit
 */
public class LogicalRule implements TypeRule
{
	private static final long serialVersionUID = 1L;
	/** operator to combine the list of operands */
	private LogicalOperator operator;
	/** a list of rules that is combined by the logical operator.
	 *  If NOT is used, the list has to contain exactly one entry. */
	private List<TypeRule> operands = new ArrayList<TypeRule>();
	
	
	/**
	 * Constructs a new LogicalRule.
	 *
	 * @param operator the logical operator (AND, OR, NOT).
	 */
	public LogicalRule(LogicalOperator operator)
	{
		this.operator = operator;
	}
	

	/**
	 * @return Returns the operator.
	 */
	public LogicalOperator getOperator()
	{
		return operator;
	}
	
	
	/**
	 * Adds a new operand, for the operator NOT, only one operand is allowed.
	 * TODO check that the NOT operator can only be used with one operand. 
	 * 
	 * @param rule a rule that is added as operand 
	 */
	public void addOperand(TypeRule rule)
	{
		operands.add(rule);
	}
	
	
	/**
	 *  Returns a list of rules that is combined by the logical operator.
	 *  If NOT is used, the list has to contain exactly one entry.
	 * @return Returns all operands.
	 */
	public List<TypeRule> getOperands()
	{
		return operands;
	}
	
	
	/**
	 * @see com.adobe.xmp.schema.model.TypeRule#accept(com.adobe.xmp.schema.model.SchemaVisitor)
	 */
	public void accept(SchemaVisitor schemaVisitor) throws XMPSchemaException
	{
		schemaVisitor.visit(this);
	}
}
